/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.comm;

import de.das.encrypter.comm.DataReceiver;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class UdpReceiver
extends Thread {
    private DatagramSocket receiverSocket;
    private DatagramPacket incommingPackage;
    private final int RECEIVER_BUFFER_SIZE = 32768;
    private final int udpReceiverPort;
    private DataReceiver dataReceiver;
    private boolean killed = false;
    private String receiverName = "";

    public UdpReceiver(int port, DataReceiver recv) throws Exception {
        this("", port, recv);
    }

    public UdpReceiver(String name, int port, DataReceiver recv) throws Exception {
        this.receiverName = name;
        this.udpReceiverPort = port;
        this.dataReceiver = recv;
        this.init();
    }

    private void init() throws Exception {
        this.receiverSocket = new DatagramSocket(this.udpReceiverPort);
        this.receiverSocket.setSoTimeout(0);
        this.receiverSocket.setReceiveBufferSize(32768);
        this.incommingPackage = new DatagramPacket(new byte[32768], 32768);
        this.setName("UDP receiver service.");
        this.start();
    }

    public void setDataReceiver(DataReceiver dataReceiver) {
        this.dataReceiver = dataReceiver;
    }

    @Override
    public void run() {
        while (!this.killed) {
            this.provideService();
        }
    }

    private void provideService() {
        try {
            this.receiverSocket.receive(this.incommingPackage);
            if (!this.killed) {
                final byte[] data = new byte[this.incommingPackage.getLength()];
                System.arraycopy(this.incommingPackage.getData(), 0, data, 0, data.length);
                Thread th = new Thread(){

                    @Override
                    public void run() {
                        UdpReceiver.this.dataReceiver.setData(UdpReceiver.this.incommingPackage.getAddress().getHostAddress(), data);
                    }
                };
                th.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void kill() {
        this.killed = true;
        this.receiverSocket.close();
        this.interrupt();
    }
}

