/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.comm;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class UdpSender {
    private DatagramSocket senderSocket = null;
    private final int udpReceiverPort;
    private final String host;
    private String senderName = "";

    public UdpSender(int port) throws Exception {
        this("127.0.0.1", port);
    }

    public UdpSender(String host, int port) throws Exception {
        this("Unnamed", host, port);
    }

    public UdpSender(String name, String host, int port) throws SocketException {
        this.senderName = name;
        this.host = host;
        this.udpReceiverPort = port;
        this.senderSocket = new DatagramSocket();
    }

    public synchronized void callServer(byte[] data) {
        this.callServer(this.host, data);
    }

    public synchronized void callServer(String host, byte[] data) {
        try {
            DatagramPacket dpn = new DatagramPacket(data, data.length, InetAddress.getByName(host), this.udpReceiverPort);
            this.senderSocket.send(dpn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

