/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.cryptoservice;

import de.das.encrypter.comm.DataReceiver;
import de.das.encrypter.comm.UdpReceiver;
import de.das.encrypter.model.EntryPointSupplier;
import de.das.encrypter.model.KeyFile;
import de.das.encrypter.model.KeyFiles;
import de.das.encrypter.processors.BlockSender;
import de.das.encrypter.processors.EncoderDecoder;
import de.das.encrypter.processors.ResultReceiver;
import de.das.encrypter.processors.TransferControl;
import de.das.encrypter.tools.HexTool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Timer;

public class CryptoServer
implements DataReceiver,
ActionListener,
ResultReceiver {
    public static final String RESPONSE_ID = "CryptoServiceResponse";
    public static final int RESPONSE_ID_LENGTH = "CryptoServiceResponse".length();
    public static final int NO_REJECTION = 0;
    public static final int KEY_UNKNOWN = 1;
    public static final int KEYS_TOO_SHORT = 2;
    public static final int NO_UNUSED_KEY_AVAILABLE = 3;
    private static Long cryptoKeyId = null;
    private UdpReceiver recv;
    private static CryptoServer cs;
    private final KeyFiles kfs;
    private final EncoderDecoder ed = new EncoderDecoder();
    private final int CONNECTION_TIME_OUT_TIME = 2000;
    private BlockSender blockSender = null;
    private Timer connectionTimeOut;
    private TransferControl transferControl;
    private int port;
    private final EntryPointSupplier eps;
    private final int MAX_REQUEST_LENGTH = 80;
    private int rejectionReason = 0;

    public static void createInstance(KeyFiles kfs, int port, EntryPointSupplier eps) throws Exception {
        cs = new CryptoServer(kfs, port, eps);
    }

    public CryptoServer(KeyFiles kfs, int port, EntryPointSupplier eps) throws Exception {
        this.kfs = kfs;
        this.port = port;
        this.eps = eps;
        this.init();
    }

    public static void setCryptoKeyId(Long id) {
        cryptoKeyId = id;
    }

    public static Long getCryptoKeyId() {
        return cryptoKeyId;
    }

    public static void newPort(int port) {
        cs.changePort(port);
    }

    private void changePort(int port) {
        this.port = port;
        this.initCommunication();
    }

    private void init() throws Exception {
        EncoderDecoder.setup("", this.kfs);
        this.transferControl = new TransferControl(this);
        this.transferControl.setupSender(null, this.port);
        this.connectionTimeOut = new Timer(2000, this);
        this.initCommunication();
    }

    @Override
    public void setData(byte[] data) {
    }

    @Override
    public void setData(String host, byte[] data) {
        try {
            this.transferControl.setHost(host, this.port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rejectionReason = 0;
        if (data.length < 80 && EncoderDecoder.isEncrypted(data)) {
            try {
                long id = EncoderDecoder.getKeyId(data);
                if (this.kfs.containsKey(id) && cryptoKeyId != null && this.kfs.containsKey(cryptoKeyId)) {
                    this.parseRequestAndStartTransfer(host, data);
                }
            }
            catch (Exception id) {
                // empty catch block
            }
            if (this.rejectionReason != 0) {
                byte[] res = new byte[RESPONSE_ID_LENGTH + 1];
                System.arraycopy(RESPONSE_ID.getBytes(), 0, res, 0, RESPONSE_ID_LENGTH);
                res[CryptoServer.RESPONSE_ID_LENGTH] = (byte)this.rejectionReason;
                this.transferControl.getSender().callServer(res);
            }
        }
    }

    private void parseRequestAndStartTransfer(String host, byte[] data) throws Exception {
        StringTokenizer tokens;
        String request = new String(data = this.ed.decrypt(data));
        if (request.contains(";") && (tokens = new StringTokenizer(request, ";")).countTokens() == 2) {
            String keyBundleName = tokens.nextToken();
            int size = Integer.parseInt(tokens.nextToken());
            Long id = this.kfs.getKeyIdByKeyName(keyBundleName);
            if (id != null) {
                byte[] pureKey = ((KeyFile)this.kfs.get(id)).getPureKeyData();
                if (pureKey.length >= size) {
                    this.startTransfer(host, id, pureKey, size);
                } else {
                    this.rejectionReason = 2;
                }
            } else {
                this.rejectionReason = 1;
            }
        }
    }

    private void startTransfer(String host, long id, byte[] key, int size) throws Exception {
        this.transferControl.setHost(host, this.port);
        int KEY_ID_LENGTH = 8;
        int ENTRY_POINT_LENGTH = 4;
        int HEADER_LENGTH = KEY_ID_LENGTH + ENTRY_POINT_LENGTH;
        byte[] keyData = new byte[size + HEADER_LENGTH];
        Integer entryPoint = this.eps.getEntryPoint(id, key);
        if (entryPoint != null) {
            HexTool.insertLongLittleEndianAt(id, 0, keyData);
            HexTool.insertIntLittleEndianAt(entryPoint.intValue(), KEY_ID_LENGTH, keyData);
            for (int i = 0; i < size; ++i) {
                Integer n = entryPoint;
                entryPoint = entryPoint + 1;
                keyData[i + HEADER_LENGTH] = key[n];
                entryPoint = entryPoint == key.length ? 0 : entryPoint;
            }
            keyData = this.ed.encrypt(entryPoint.intValue(), ((KeyFile)this.kfs.get(cryptoKeyId)).getKey(), keyData, "---");
            this.recv.setDataReceiver(this.transferControl);
            this.transferControl.setBreakSender(false);
            this.transferControl.setTransferResult(-1);
            this.connectionTimeOut.start();
            this.blockSender = new BlockSender(keyData, null, this.transferControl, this.connectionTimeOut);
            this.blockSender.start();
            while (this.transferControl.getTransferResult() == -1 && !this.transferControl.isBreakSender()) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            this.recv.setDataReceiver(this);
        } else {
            this.rejectionReason = 3;
        }
    }

    private void initCommunication() {
        if (this.recv != null) {
            this.recv.kill();
        }
        try {
            this.recv = new UdpReceiver("Crypto Server", this.port + 1, this.transferControl);
            this.recv.setDataReceiver(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.connectionTimeOut)) {
            this.connectionTimeOut.stop();
            this.transferControl.setBreakSender(true);
            if (this.blockSender != null || this.transferControl.isWaitingForInfo()) {
                if (this.blockSender != null) {
                    this.blockSender.interrupt();
                    this.blockSender = null;
                }
                this.initCommunication();
            }
        }
    }

    @Override
    public void setResult(int result, String info) {
        switch (result) {
            case 0: {
                this.connectionTimeOut.stop();
                break;
            }
            case 1: {
                this.connectionTimeOut.stop();
                this.transferControl.setTransferResult(1);
                break;
            }
            case 2: {
                this.connectionTimeOut.stop();
                this.transferControl.setTransferResult(0);
                break;
            }
            case 3: {
                this.connectionTimeOut.stop();
            }
        }
    }
}

