/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.examples;

import de.das.encrypter.comm.DataReceiver;
import de.das.encrypter.comm.UdpReceiver;
import de.das.encrypter.comm.UdpSender;
import de.das.encrypter.cryptoservice.CryptoServer;
import de.das.encrypter.model.KeyFile;
import de.das.encrypter.model.KeyFiles;
import de.das.encrypter.processors.Assembler;
import de.das.encrypter.processors.EncoderDecoder;
import de.das.encrypter.processors.KeyTransfer;
import de.das.encrypter.tools.CRC;
import de.das.encrypter.tools.HexTool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.SocketException;
import java.util.Arrays;
import javax.swing.Timer;

public class CryptoServiceUser
implements ActionListener,
DataReceiver {
    private final String IMAGE_FILE_PATH = ".\\Tests\\meer50.jpg";
    private final String ENCRYPTED_IMAGE_FILE_PATH = ".\\Tests\\af45e90d3210fa3";
    private final String KEY_PATH = ".\\Tests\\128kB";
    private final String KEY_NAME = "5MB";
    private final EncoderDecoder ed = new EncoderDecoder();
    private UdpReceiver recv;
    private UdpSender sender;
    private final int port = 44444;
    private String host = "127.0.0.1";
    private Assembler assembler = null;
    private byte[] buffer;
    private int expectedBlockCount;
    private final int CONNECTION_TIME_OUT_TIME = 2000;
    private Timer connectionTimeOut;
    private KeyFiles kfs;
    private static boolean received = false;
    private static boolean success;
    private static boolean timeout;
    private static int rejectReason;

    public static void main(String[] args) {
        try {
            new CryptoServiceUser().execute();
            while (!received) {
                Thread.sleep(100L);
            }
            if (success) {
                System.out.println("Request successful");
            } else if (timeout) {
                System.out.println("Crypto Service not available.");
            } else {
                switch (rejectReason) {
                    case 1: {
                        System.out.println("Rejection because unknown key bundle.");
                        break;
                    }
                    case 2: {
                        System.out.println("Rejection because requested key too long.");
                        break;
                    }
                    case 3: {
                        System.out.println("Rejection because no more unused key available.");
                        break;
                    }
                    default: {
                        System.out.println("Rejection because unknown reason.");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public CryptoServiceUser() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.connectionTimeOut = new Timer(2000, this);
        this.prepareReceiver();
        this.prepareSender();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.connectionTimeOut)) {
            this.connectionTimeOut.stop();
            received = true;
            timeout = true;
        }
    }

    private void execute() throws Exception {
        timeout = false;
        File imageFile = new File(".\\Tests\\meer50.jpg");
        KeyFile kf = KeyFile.takeAsKey(new File(".\\Tests\\128kB"));
        if (kf != null) {
            this.kfs = new KeyFiles();
            this.kfs.put(kf.getId(), kf);
            EncoderDecoder.setup("", this.kfs);
            String request = "5MB;" + (int)imageFile.length();
            byte[] requestData = this.ed.encrypt(400L, kf.getKey(), request.getBytes());
            this.connectionTimeOut.start();
            this.sender.callServer("127.0.0.1", requestData);
        }
    }

    @Override
    public void setData(String host, byte[] data) {
        this.setData(data);
    }

    @Override
    public void setData(byte[] data) {
        this.connectionTimeOut.stop();
        if (data.length == KeyTransfer.EOT.length && Arrays.equals(data, KeyTransfer.EOT)) {
            success = true;
            this.saveKey();
        } else if (data.length > CryptoServer.RESPONSE_ID_LENGTH && HexTool.byteToString(data, 0, CryptoServer.RESPONSE_ID_LENGTH).equals("CryptoServiceResponse")) {
            success = false;
            rejectReason = data[CryptoServer.RESPONSE_ID_LENGTH];
            received = true;
        } else {
            if (this.assembler == null) {
                try {
                    int dataSize = HexTool.byteToIntBigEndian(4, data);
                    this.connectionTimeOut.start();
                    this.assembler = new Assembler(dataSize, null);
                    this.buffer = new byte[16384];
                    this.expectedBlockCount = 0;
                    success = false;
                }
                catch (Exception e) {
                    this.sender.callServer("Break".getBytes());
                }
            } else {
                this.connectionTimeOut.restart();
            }
            int bufferSize = HexTool.byteToIntBigEndian(8, data);
            if (bufferSize != this.buffer.length) {
                this.buffer = new byte[bufferSize];
            }
            System.arraycopy(data, 12, this.buffer, 0, this.buffer.length);
            int currentBlockCount = HexTool.byteToIntBigEndian(0, data);
            int crc = HexTool.byteToIntBigEndian(data.length - 4, data);
            if (crc == (int)CRC.getCRC_32(data, 4) && currentBlockCount == this.expectedBlockCount) {
                this.assembler.setData(this.buffer);
                ++this.expectedBlockCount;
                this.sender.callServer(HexTool.intToByteArray(currentBlockCount));
            } else {
                this.sender.callServer("Break".getBytes());
            }
        }
    }

    private void prepareSender() throws SocketException {
        this.sender = new UdpSender("CSU Sender", this.host, 44445);
    }

    private void prepareReceiver() throws Exception {
        if (this.recv != null) {
            this.recv.kill();
        }
        this.recv = new UdpReceiver("USC Receiver", 44444, this);
    }

    private void saveKey() {
        this.sender.callServer(KeyTransfer.VALID);
        byte[] data = this.assembler.getData();
        try {
            data = this.ed.decrypt(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int KEY_ID_LENGTH = 8;
        int ENTRY_POINT_LENGTH = 4;
        int HEADER_LENGTH = KEY_ID_LENGTH + ENTRY_POINT_LENGTH;
        long id = HexTool.byteToLongLittleEndian(data, 0);
        int entryPoint = HexTool.byteToIntLittleEndian(KEY_ID_LENGTH, data);
        byte[] pureKey = new byte[data.length - HEADER_LENGTH];
        System.arraycopy(data, HEADER_LENGTH, pureKey, 0, pureKey.length);
        System.out.println("Key id: " + id);
        System.out.println("Entry point: " + entryPoint + " Length: " + (data.length - 4));
        this.assembler = null;
        try {
            File imageFile = new File(".\\Tests\\meer50.jpg");
            byte[] imgBuffer = new byte[(int)imageFile.length()];
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(imageFile));){
                in.read(imgBuffer);
            }
            byte[] eData = this.ed.encrypt(id, pureKey, entryPoint, imgBuffer, imageFile.getName());
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(".\\Tests\\af45e90d3210fa3"));){
                out.write(eData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        received = true;
    }
}

