/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.examples;

import de.das.encrypter.model.KeyFile;
import de.das.encrypter.model.KeyFiles;
import de.das.encrypter.processors.EncoderDecoder;
import de.das.encrypter.tools.HexTool;
import java.io.File;

public class EncryptionDecryptionExample {
    private final String KEY_PATH = "C:\\Bundle\\1MB";
    private final String ORIGINAL_TEXT = "This example shows how data can be encrypted and decrypted.";

    public static void main(String[] args) {
        try {
            new EncryptionDecryptionExample().execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void execute() throws Exception {
        KeyFile kf = KeyFile.takeAsKey(new File("C:\\Bundle\\1MB"));
        if (kf != null) {
            KeyFiles kfs = new KeyFiles();
            kfs.put(kf.getId(), kf);
            EncoderDecoder.setup(kfs);
            EncoderDecoder ed = new EncoderDecoder();
            int entryPoint = 126;
            byte[] usedKeyPart = KeyFile.provideKeyPart(kf.getKey(), entryPoint, "This example shows how data can be encrypted and decrypted.".length());
            byte[] encryptedData = ed.encrypt(entryPoint, kf.getKey(), "This example shows how data can be encrypted and decrypted.".getBytes());
            System.out.println("This example shows how data can be encrypted and decrypted.");
            System.out.println("\nOriginal text bytes:");
            HexTool.printlnBuffer("This example shows how data can be encrypted and decrypted.".getBytes());
            System.out.println("\nKey part bytes:");
            HexTool.printlnBuffer(usedKeyPart);
            System.out.println("\nEncrypted data bytes:");
            HexTool.printlnBuffer(ed.getPureEncryptedData(encryptedData));
            System.out.println("\nEncrypted data bytes plus header:");
            HexTool.printlnBuffer(encryptedData);
            byte[] decryptedData = ed.decrypt(encryptedData);
            System.out.println("\nDecrypted data bytes:");
            HexTool.printlnBuffer(decryptedData);
            System.out.println(new String(decryptedData));
        }
    }
}

