/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.examples;

import de.das.encrypter.model.KeyFile;
import de.das.encrypter.tools.HexTool;
import de.das.encrypter.tools.KeyFileFileFilter;
import de.das.encrypter.tools.KeyQualityAssessor;
import de.das.encrypter.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class KeyAnalyzer
extends JFrame
implements ActionListener {
    private final Dimension SIZE = new Dimension(440, 440);
    private final Dimension BUTTON_SIZE = new Dimension(32, 32);
    private final String SOURCE_FILE_NAME_CONTAINER = ".\\Tests\\Probe";
    private String source = null;
    private final String LAST_PATH = "./PATH";
    private String lastSelectedPath;
    private final float[] norm = new float[256];
    private Double[] qualityValues;
    private JButton btnOpen;
    private File bundleFile;
    private Image img;
    private byte[] key;
    private Display display;

    public static void main(String[] args) {
        try {
            new KeyAnalyzer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KeyAnalyzer() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.lastSelectedPath = "./";
        try (BufferedReader in2 = new BufferedReader(new FileReader("./PATH"));){
            this.lastSelectedPath = in2.readLine();
        }
        catch (Exception in2) {
            // empty catch block
        }
        ImageIcon icon = new ImageIcon(this.loadImage("open.png"));
        this.btnOpen = new JButton(icon);
        this.btnOpen.setPreferredSize(this.BUTTON_SIZE);
        this.btnOpen.addActionListener(this);
        this.btnOpen.setBorder(null);
        this.btnOpen.setRolloverIcon(new ImageIcon(this.loadImage("openOver.png")));
        this.btnOpen.setToolTipText("Select a key file");
        this.display = new Display();
        this.calculate();
        this.setPreferredSize(this.SIZE);
        this.setTitle("Rel. frequency of byte values");
        this.img = this.loadImage("appIcon.png");
        this.setIconImage(this.img);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.display, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    private void calculate() throws Exception {
        if (this.source != null) {
            int start;
            this.bundleFile = new File(this.source);
            this.key = new byte[(int)this.bundleFile.length()];
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.source));){
                bis.read(this.key);
            }
            int[] counts = new int[256];
            int max = 0;
            for (int j = start = KeyFile.getKeyStartingPoint(this.key); j < this.key.length; ++j) {
                byte b = this.key[j];
                int n = HexTool.byteToInt(b);
                counts[n] = counts[n] + 1;
            }
            for (int c : counts) {
                if (c <= max) continue;
                max = c;
            }
            for (int jnx = 1; jnx < this.norm.length; ++jnx) {
                this.norm[jnx] = (float)counts[jnx] / (float)max;
            }
            KeyQualityAssessor kqa = new KeyQualityAssessor();
            this.qualityValues = kqa.determineQuality(this.key);
            this.display.repaint();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            super.processWindowEvent(e);
            System.exit(0);
        } else {
            super.processWindowEvent(e);
        }
    }

    private Image loadImage(String imgName) {
        BufferedImage img = null;
        URL url = KeyAnalyzer.class.getResource("/de/das/encrypter/images/" + imgName);
        try {
            InputStream fis = url.openStream();
            img = ImageIO.read(fis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    private String getSourcePath() {
        String path = null;
        try (BufferedReader in = new BufferedReader(new FileReader(".\\Tests\\Probe"));){
            path = in.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnOpen)) {
            JFileChooser fc = new JFileChooser(this.lastSelectedPath);
            fc.setFileFilter(new KeyFileFileFilter("Key file"));
            fc.setAcceptAllFileFilterUsed(false);
            if (fc.showOpenDialog(this) == 0) {
                this.source = fc.getSelectedFile().getAbsolutePath();
                try {
                    this.calculate();
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(this, "Calculation failed", "Key analyzer", 0);
                }
            }
            this.lastSelectedPath = fc.getCurrentDirectory().getAbsolutePath();
            this.saveLastPath();
        }
    }

    private void saveLastPath() {
        try (BufferedWriter out = new BufferedWriter(new FileWriter("./PATH"));){
            out.write(this.lastSelectedPath + "\r\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Display
    extends JPanel {
        private final int LEFT_BORDER = 30;
        private final int RIGHT_BORDER = 30;
        private final int TOP_BORDER = 30;
        private final int BOTTOM_BORDER = 30;
        private final int[] HORI_TEXTS = new int[]{0, 64, 128, 192, 255};

        public Display() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this.add((Component)KeyAnalyzer.this.btnOpen, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(130, 0, 0, 50), 0, 0));
        }

        @Override
        public void paintComponent(Graphics g) {
            int x;
            String str;
            int j;
            int y;
            super.paintComponent(g);
            int hMax = this.getHeight();
            int y0 = hMax - 30;
            int DY = y0 - 30;
            g.setColor(Color.WHITE);
            g.fillRect(30, 30, 255, y0 - 30);
            g.drawImage(KeyAnalyzer.this.img, this.getWidth() - 30 - KeyAnalyzer.this.img.getWidth(null), 30, null);
            g.setColor(Color.BLACK);
            if (KeyAnalyzer.this.source != null) {
                g.setColor(new Color(128, 128, 255, 20));
                g.fillRect(30, 30, 255, (int)((double)DY * (1.0 - KeyAnalyzer.this.qualityValues[1])));
                y = (int)((double)y0 - (double)DY * KeyAnalyzer.this.qualityValues[0]);
                g.setColor(Color.BLUE);
                g.drawLine(30, y, 285, y);
                g.setColor(Color.BLACK);
                for (int i = 1; i < KeyAnalyzer.this.norm.length - 1; ++i) {
                    g.drawLine(30 + i, (int)((float)y0 - (float)DY * KeyAnalyzer.this.norm[i]), 30 + i + 1, (int)((float)y0 - (float)DY * KeyAnalyzer.this.norm[i + 1]));
                }
            }
            g.drawLine(30, y0, 285, y0);
            g.drawLine(30, y0, 30, 30);
            FontMetrics fm = g.getFontMetrics();
            y = y0 + fm.getHeight();
            for (j = 0; j < this.HORI_TEXTS.length; ++j) {
                str = Integer.toString(this.HORI_TEXTS[j]);
                int x0 = 30 + this.HORI_TEXTS[j];
                x = x0 - fm.stringWidth(str) / 2;
                g.drawLine(x0, y0 - 2, x0, y0 + 2);
                g.drawString(str, x, y);
            }
            x = 28;
            for (j = 1; j <= 10; ++j) {
                str = Tools.getFormatted("%1$3.1f", (double)j / 10.0);
                y = y0 - (int)((double)(DY * j) / 10.0);
                g.drawLine(x, y, x + 4, y);
                g.drawString(str, x - 4 - fm.stringWidth(str), y + fm.getHeight() / 2);
            }
            int leftTextBorder = this.getWidth() - 120;
            int topTextBorder = this.getHeight() - 100;
            if (KeyAnalyzer.this.source != null) {
                g.drawString("Analyzed key bundle:", leftTextBorder, topTextBorder - 6 * fm.getHeight());
                g.drawString(KeyAnalyzer.this.bundleFile.getName(), leftTextBorder, topTextBorder - 5 * fm.getHeight());
                g.drawString("Key bundle size:", leftTextBorder, topTextBorder - 3 * fm.getHeight());
                g.drawString(Integer.toString(Math.round((float)KeyFile.getPureKeyData(KeyAnalyzer.this.key).length / 1024.0f)) + "kB", leftTextBorder, topTextBorder - 2 * fm.getHeight());
                g.drawString("Equal distribution", leftTextBorder, topTextBorder);
                g.drawString(Tools.getFormatted("%1$6.4f", KeyAnalyzer.this.qualityValues[0]), leftTextBorder, topTextBorder + fm.getHeight());
                g.drawString("Scattering", leftTextBorder, topTextBorder + fm.getHeight() * 3);
                g.drawString(Tools.getFormatted("%1$6.4f", 1.0 - KeyAnalyzer.this.qualityValues[1]), leftTextBorder, topTextBorder + fm.getHeight() * 4);
            }
        }
    }
}

