/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.examples;

import de.das.encrypter.model.KeyFileLocation;
import de.das.encrypter.model.KeyFiles;
import de.das.encrypter.model.KeyFilesSearchReceiver;
import de.das.encrypter.processors.KeyFilesSearcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class KeySearchingExample
extends JFrame
implements KeyFilesSearchReceiver {
    private final Dimension SIZE = new Dimension(480, 480);
    private final Display display = new Display();
    private final KeyFiles keyFiles = new KeyFiles();
    private final boolean searchingAllowed = true;
    private boolean searching;
    private ArrayList<File> bundleFolders;
    private ArrayList<KeyFileLocation> keyFileLocations;

    public static void main(String[] args) {
        try {
            new KeySearchingExample().execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void execute() throws Exception {
        this.setPreferredSize(this.SIZE);
        this.setTitle("Keys searching example");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.display, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        KeyFilesSearcher.createInstance(this);
        this.setVisible(true);
    }

    @Override
    public void synchronizeKeyFilesList(KeyFiles hashMap) {
        for (Long id : hashMap.keySet()) {
            this.getKeyFiles().put(id, hashMap.get(id));
        }
        this.display.update();
    }

    @Override
    public KeyFiles getKeyFiles() {
        return this.keyFiles;
    }

    @Override
    public void setKeyFileLocations(ArrayList<KeyFileLocation> keyFileLocations) {
        this.keyFileLocations = keyFileLocations;
    }

    @Override
    public void setKeyFileSearching(boolean b) {
        this.searching = b;
        this.display.update();
    }

    @Override
    public void setBundleFolders(ArrayList<File> bundleFolders) {
        this.bundleFolders = bundleFolders;
        this.display.update();
    }

    @Override
    public boolean isSearchingAllowed() {
        return true;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            super.processWindowEvent(e);
            System.exit(0);
        } else {
            super.processWindowEvent(e);
        }
    }

    class Display
    extends JPanel {
        private final JTextArea taResults = new JTextArea();

        public Display() {
            this.init();
        }

        private void init() {
            this.taResults.setEditable(false);
            JScrollPane scroller = new JScrollPane(this.taResults, 20, 30);
            this.setLayout(new GridBagLayout());
            this.add((Component)scroller, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(20, 20, 20, 20), 0, 0));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintBackground(g);
        }

        void update() {
            String results = "Bundle folders found:\n" + (KeySearchingExample.this.bundleFolders == null ? "\n" : KeySearchingExample.this.bundleFolders.toString() + "\n\nKey file locations:\n");
            if (KeySearchingExample.this.keyFileLocations != null) {
                ArrayList list = KeySearchingExample.this.keyFileLocations;
                for (KeyFileLocation kfl : list) {
                    results = results + this.expandTo(kfl.getKeyId(), 16) + " " + kfl.getKeyName() + "  --->  " + kfl.getKeyLocation().replace("\\\\", "\\") + "\n\r";
                }
            }
            this.taResults.setText(results);
            this.repaint();
        }

        private String expandTo(long id, int n) {
            String s = Long.toString(id);
            while (s.length() < n) {
                s = "0" + s;
            }
            return s;
        }

        private void paintBackground(Graphics g) {
            if (KeySearchingExample.this.searching) {
                g.setColor(new Color(120, 255, 120));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

