/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.examples;

import de.das.encrypter.model.KeyFile;
import de.das.encrypter.tools.HexTool;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PatternChecker {
    private int patternSize = 3;

    public static void main(String[] args) {
        try {
            new PatternChecker().execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void execute() throws Exception {
        File f = new File("./16.000-1");
        KeyFile.create(f, 16000);
        HashMap results = new HashMap();
        byte[] key = new byte[(int)f.length()];
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            bis.read(key);
        }
        int start = KeyFile.getKeyStartingPoint(key);
        do {
            results.clear();
            byte[] pattern = new byte[this.patternSize];
            byte[] check = new byte[this.patternSize];
            for (int i = start; i < key.length - this.patternSize; ++i) {
                System.arraycopy(key, i, pattern, 0, this.patternSize);
                String patternString = HexTool.byteArrayToString(pattern);
                if (results.containsKey(patternString)) continue;
                ArrayList<String> references = new ArrayList<String>();
                for (int j = i + 1; j < key.length - this.patternSize; ++j) {
                    System.arraycopy(key, j, check, 0, this.patternSize);
                    if (!Arrays.equals(pattern, check)) continue;
                    references.add(Integer.toString(i) + "-" + Integer.toString(j));
                }
                if (references.isEmpty() || results.containsKey(patternString)) continue;
                results.put(patternString, references);
            }
            if (!results.isEmpty()) {
                try (BufferedWriter out = new BufferedWriter(new FileWriter(f.getAbsolutePath() + "-PatternCheck-" + Integer.toString(this.patternSize) + ".txt"));){
                    for (String p : results.keySet()) {
                        ArrayList refs = (ArrayList)results.get(p);
                        out.write(p + ": " + HexTool.fillLeadingPositions(Integer.toString(refs.size()), 3, ' '));
                        out.write("  ");
                        for (String s : refs) {
                            out.write(s + "; ");
                        }
                        out.write("\r\n");
                    }
                }
            }
            ++this.patternSize;
        } while (!results.isEmpty());
    }
}

