/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.examples;

import de.das.encrypter.model.KeyFile;
import de.das.encrypter.tools.HexTool;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PatternCompare {
    private final String SOURCE = ".\\Tests\\PatternCompare\\TestKey_";
    private final int START_PATTERN_SIZE = 3;
    private int patternSize;

    public static void main(String[] args) {
        try {
            PatternCompare pc = new PatternCompare();
            for (int i0 = 0; i0 < 20; ++i0) {
                for (int i1 = i0 + 1; i1 < 20; ++i1) {
                    pc.execute(i0, i1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void execute(int i0, int i1) throws Exception {
        this.patternSize = 3;
        HashMap results = new HashMap();
        File fSource = new File(".\\Tests\\PatternCompare\\TestKey_" + Integer.toString(i0));
        byte[] key = new byte[(int)fSource.length()];
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fSource));){
            bis.read(key);
        }
        File f = new File(".\\Tests\\PatternCompare\\TestKey_" + Integer.toString(i1));
        byte[] keyComp = new byte[(int)f.length()];
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            bis.read(keyComp);
        }
        int startKey = KeyFile.getKeyStartingPoint(key);
        do {
            results.clear();
            byte[] pattern = new byte[this.patternSize];
            byte[] check = new byte[this.patternSize];
            for (int i = startKey; i < key.length - this.patternSize; ++i) {
                System.arraycopy(key, i, pattern, 0, this.patternSize);
                String patternString = HexTool.byteArrayToString(pattern);
                if (results.containsKey(patternString)) continue;
                ArrayList<String> references = new ArrayList<String>();
                for (int j = i + 1; j < key.length - this.patternSize; ++j) {
                    System.arraycopy(keyComp, j, check, 0, this.patternSize);
                    if (!Arrays.equals(pattern, check)) continue;
                    references.add(Integer.toString(i) + "-" + Integer.toString(j));
                }
                if (references.isEmpty()) continue;
                results.put(patternString, references);
            }
            if (!results.isEmpty()) {
                try (BufferedWriter out = new BufferedWriter(new FileWriter(f.getAbsolutePath() + "-" + fSource.getName() + "-PatternCompare-" + Integer.toString(this.patternSize) + ".txt"));){
                    for (String p : results.keySet()) {
                        ArrayList refs = (ArrayList)results.get(p);
                        out.write(p + ": " + HexTool.fillLeadingPositions(Integer.toString(refs.size()), 3, ' '));
                        out.write("  ");
                        for (String s : refs) {
                            out.write(s + "; ");
                        }
                        out.write("\r\n");
                    }
                }
            }
            ++this.patternSize;
        } while (!results.isEmpty());
    }
}

