/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.fourier;

import de.das.encrypter.fourier.Complex;

public class FFT {
    private static double log2(double a) {
        return Math.log(a) / Math.log(2.0);
    }

    private static int checkPowerOfTwo(int N) throws Exception {
        double f;
        int result = -1;
        if (N == 0) {
            throw new Exception("Input size is zero.");
        }
        double l = FFT.log2(N);
        double c = Math.ceil(l);
        result = c == (f = Math.floor(l)) ? 0 : (int)Math.pow(2.0, c) - N;
        return result;
    }

    private static Complex[] makePowerOfTwoSize(Complex[] arr, int fillCount) {
        Complex[] newArr = new Complex[arr.length + fillCount];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        for (int i = arr.length; i < newArr.length; ++i) {
            newArr[i] = new Complex(0.0, 0.0);
        }
        return newArr;
    }

    private static int getReversedNum(int num, int numOfBits) {
        int d = 0;
        for (int i = 0; i < numOfBits; ++i) {
            int j = numOfBits - 1 - i;
            int k = num >> j;
            byte a = (byte)(k & 1);
            d += a << i;
        }
        return d;
    }

    private static Complex[] arrange4fft(Complex[] src, int numOfBits) throws Exception {
        Complex[] arrangedSrc = new Complex[src.length];
        for (int i = 0; i < src.length; ++i) {
            int j = FFT.getReversedNum(i, numOfBits);
            arrangedSrc[j] = src[i];
        }
        return arrangedSrc;
    }

    private static Complex[] calculateW(int N, boolean isInverse) {
        Complex[] W = null;
        double T = 0.0;
        int N2 = N / 2;
        W = new Complex[N2];
        T = Math.PI * 2 / (double)N;
        double theta = 0.0;
        if (isInverse) {
            for (int i = 0; i < N2; ++i) {
                theta = -(T * (double)i);
                W[i] = new Complex(Math.cos(theta), -Math.sin(theta));
            }
        } else {
            for (int i = 0; i < N2; ++i) {
                theta = T * (double)i;
                W[i] = new Complex(Math.cos(theta), -Math.sin(theta));
            }
        }
        return W;
    }

    private static void regionFFT(Complex[][] X, int src, int tgt, int s, int size, int kJump, Complex[] W) {
        int k = 0;
        int e = s + size / 2 - 1;
        Complex T = null;
        int half = size / 2;
        for (int i = s; i <= e; ++i) {
            T = Complex.multiply(X[src][i + half], W[k]);
            X[tgt][i] = Complex.add(X[src][i], T);
            X[tgt][i + half] = Complex.subtract(X[src][i], T);
            k += kJump;
        }
    }

    private static Complex[] fft_forward(Complex[] src, boolean isInverse) throws Exception {
        int resultIdx;
        int i;
        int N = src.length;
        int fillCount = 0;
        fillCount = FFT.checkPowerOfTwo(N);
        if (fillCount > 0) {
            src = FFT.makePowerOfTwoSize(src, fillCount);
        } else if (fillCount < 0) {
            throw new Exception("Something wrong: while calculateing filling count from the input data");
        }
        N = src.length;
        int totalLoop = (int)FFT.log2(N);
        Complex[] arrangedSrc = FFT.arrange4fft(src, totalLoop);
        Complex[] W = FFT.calculateW(N, isInverse);
        Complex[][] X = new Complex[2][N];
        System.arraycopy(arrangedSrc, 0, X[0], 0, N);
        int srcIdx = 0;
        int tgtIdx = 0;
        int kJump = 0;
        int regionSize = 0;
        for (int curLoop = 0; curLoop < totalLoop; ++curLoop) {
            tgtIdx = (tgtIdx + 1) % 2;
            srcIdx = (tgtIdx + 1) % 2;
            regionSize = 1 << curLoop + 1;
            kJump = 1 << totalLoop - curLoop - 1;
            for (i = 0; i < N; i += regionSize) {
                FFT.regionFFT(X, srcIdx, tgtIdx, i, regionSize, kJump, W);
            }
        }
        int n = resultIdx = (totalLoop & 1) == 0 ? 0 : 1;
        if (isInverse) {
            for (i = 0; i < N; ++i) {
                X[resultIdx][i] = Complex.divideR(X[resultIdx][i], N);
            }
        }
        return X[resultIdx];
    }

    public static Complex[] fft(double[] src) throws Exception {
        return FFT.fft(src, -1);
    }

    private static Complex[] fft(double[] src, int roundDigit) throws Exception {
        Complex[] complexSrc = new Complex[src.length];
        for (int i = 0; i < src.length; ++i) {
            complexSrc[i] = new Complex(src[i], 0.0);
        }
        Complex[] X = FFT.fft_forward(complexSrc, false);
        if (roundDigit >= 0) {
            double d = Math.pow(10.0, roundDigit);
            for (int i = 0; i < X.length; ++i) {
                X[i] = new Complex((double)Math.round(X[i].re * d) / d, (double)Math.round(X[i].im * d) / d);
            }
        }
        return X;
    }

    public static double[] ifft(Complex[] src) throws Exception {
        return FFT.ifft(src, -1);
    }

    private static double[] ifft(Complex[] src, int roundDigit) throws Exception {
        Complex[] complexArr = FFT.fft_forward(src, true);
        double[] x = new double[complexArr.length];
        if (roundDigit >= 0) {
            double d = Math.pow(10.0, roundDigit);
            for (int i = 0; i < x.length; ++i) {
                x[i] = (double)Math.round(complexArr[i].re * d) / d;
            }
        } else {
            for (int i = 0; i < x.length; ++i) {
                x[i] = complexArr[i].re;
            }
        }
        return x;
    }
}

