/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.model;

import de.das.encrypter.model.Key;
import de.das.encrypter.tools.CRC;
import de.das.encrypter.tools.HexTool;
import de.das.encrypter.tools.KeyQualityAssessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;

public class KeyFile
implements Key {
    public static final int HEADER_LENGTH = 24;
    public static final int CRC_LENGTH = 4;
    public static final int HEADER_LENGTH_PLUS_NAME_AMOUNT = 26;
    private static int lastEntryPointAdd;
    private final long id;
    private final String path;
    private final int length;
    private Integer pureKeyDataLength = null;
    private final String driveLetter;
    private final String keyName;
    private static Random random;
    private byte[] key;
    private Integer used = null;

    public KeyFile(long id, byte[] key, String driveLetter) {
        this.id = id;
        this.key = key;
        this.driveLetter = driveLetter;
        this.length = key.length;
        this.path = null;
        this.keyName = KeyFile.getKeyName(key);
    }

    public KeyFile(long id, String path, int length) {
        this(id, path, length, null);
    }

    public KeyFile(long id, String path, int length, byte[] key) {
        this.id = id;
        this.path = path;
        this.length = length;
        this.driveLetter = path.substring(0, 1);
        this.keyName = new File(path).getName();
        this.key = key;
    }

    public long getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public int getLength() {
        return this.length;
    }

    public static Long getKeyFileIdentifier(byte[] dataStart) {
        Long id = null;
        if (dataStart.length >= 24) {
            byte[] keyword = new byte["KEYFILE_".length()];
            System.arraycopy(dataStart, 0, keyword, 0, keyword.length);
            if (new String(keyword).equals("KEYFILE_")) {
                byte[] idBytes = new byte[16];
                System.arraycopy(dataStart, "KEYFILE_".length(), idBytes, 0, 16);
                try {
                    id = Long.parseLong(new String(idBytes), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return id;
    }

    public static Long getKeyFileIdentifier(File f) {
        Long id;
        try {
            byte[] header = new byte[24];
            try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
                raf.read(header);
            }
            id = KeyFile.getKeyFileIdentifier(header);
        }
        catch (Exception e) {
            id = null;
        }
        return id;
    }

    public String toString() {
        int pureLength = 0;
        try {
            pureLength = this.getPureKeyDataLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.keyName + " (" + this.driveLetter + " - " + (this.length <= 1024 ? Integer.toString(this.length) + "B)" : (this.length <= 0x100000 ? Integer.toString(this.length / 1024) + "kB)" : Integer.toString(this.length / 1024 / 1024) + "MB)")) + (this.used != null ? " [" + KeyFile.insertThousandsSeparators(Integer.toString(pureLength - this.used)) + "]" : "");
    }

    public static void create(File target, String contentFile) throws Exception {
        File cf = new File(contentFile);
        byte[] content = new byte[(int)cf.length()];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(cf));){
            in.read(content);
        }
        for (int i = 0; i < content.length; ++i) {
            if (content[i] != 0) continue;
            content[i] = (byte)random.nextInt(1, 256);
        }
        byte[] key = KeyFile.create(content, target.getName());
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));){
            bos.write(key);
        }
    }

    public static byte[] create(byte[] data, String name) {
        long crc = CRC.getCRC_32(data);
        String header = "KEYFILE_" + HexTool.toTwoHexQuad((int)(crc >> 32 & 0xFFFFFFFFFFFFFFFFL)) + HexTool.toTwoHexQuad((int)(crc & 0xFFFFFFFFFFFFFFFFL));
        header = header + HexTool.toHex((byte)name.getBytes().length) + name;
        byte[] headerBytes = header.getBytes();
        byte[] key = new byte[data.length + headerBytes.length + 4];
        System.arraycopy(headerBytes, 0, key, 0, headerBytes.length);
        System.arraycopy(data, 0, key, headerBytes.length, data.length);
        long crcValue = CRC.getCRC_32(key, 4);
        HexTool.insertIntBigEndianAt(crcValue, key.length - 4, key);
        return key;
    }

    public static void create(File target, int length) throws Exception {
        KeyFile.create(target, length, System.currentTimeMillis(), false);
    }

    public static void create(File target, int length, boolean balanced) throws Exception {
        KeyFile.create(target, length, System.currentTimeMillis(), balanced);
    }

    public static void create(File target, int length, long seed, boolean balanced) throws Exception {
        byte[] key = KeyFile.create(target.getName(), length, seed, balanced);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));){
            bos.write(key);
        }
    }

    public static byte[] create(String name, int length, long seed, boolean balanced) throws Exception {
        if (length < 128) {
            throw new Exception("Too small");
        }
        random = new Random(System.currentTimeMillis());
        String header = "KEYFILE_" + HexTool.toTwoHexQuad((int)(seed >> 32 & 0xFFFFFFFFFFFFFFFFL)) + HexTool.toTwoHexQuad((int)(seed & 0xFFFFFFFFFFFFFFFFL));
        header = header + HexTool.toHex((byte)name.getBytes().length) + name;
        byte[] headerBytes = header.getBytes();
        byte[] key = new byte[length + headerBytes.length];
        System.arraycopy(headerBytes, 0, key, 0, headerBytes.length);
        for (int inx = header.length(); inx < key.length; ++inx) {
            seed = KeyFile.develope(inx, seed, key);
        }
        long crcValue = CRC.getCRC_32(key, 4);
        HexTool.insertIntBigEndianAt(crcValue, key.length - 4, key);
        if (balanced) {
            key = KeyFile.harmonicallyBalance(key, 1.0);
        }
        return key;
    }

    private static long develope(int inx, long seed, byte[] key) {
        key[inx] = (byte)(seed >> 16 & 0xFFL);
        key[inx] = key[inx] == 0 ? (byte)random.nextInt(1, 256) : key[inx];
        seed ^= (seed >> 1) + 1L;
        seed += random.nextLong();
        return seed ^= System.nanoTime();
    }

    public static void createPseudoRandomKey(File f, int length, long seed) throws Exception {
        KeyFile.createPseudoRandomKey(f, length, seed, false);
    }

    public static void createPseudoRandomKey(File f, int length, long seed, boolean balanced) throws Exception {
        byte[] pureKeyData = new byte[length];
        Random random = new Random(seed);
        random.nextBytes(pureKeyData);
        for (int i = 0; i < pureKeyData.length; ++i) {
            if (pureKeyData[i] != 0) continue;
            pureKeyData[i] = (byte)random.nextInt(1, 256);
        }
        byte[] keyBundle = KeyFile.create(pureKeyData, f.getName());
        if (balanced) {
            keyBundle = KeyFile.harmonicallyBalance(keyBundle, 1.0);
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            out.write(keyBundle);
        }
    }

    public boolean equals(Object obj) {
        boolean equ;
        boolean bl = equ = obj != null && obj instanceof KeyFile;
        if (equ) {
            KeyFile kf = (KeyFile)obj;
            equ = kf.id == this.id;
            equ = equ && (kf.getPath() == null && this.getPath() == null || kf.getPath() != null && kf.getPath().equals(this.getPath()));
            equ = equ && kf.driveLetter.equals(this.driveLetter);
        }
        return equ;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (int)(this.id ^ this.id >>> 32);
        hash = 83 * hash + Objects.hashCode(this.path);
        return hash;
    }

    public static boolean isValidKey(byte[] key) {
        return KeyFile.isValidKey(key, false);
    }

    public static boolean isValidKey(byte[] key, boolean withoutCrcCheck) {
        boolean valid;
        byte[] keyStart = new byte[24];
        boolean crcOk = true;
        System.arraycopy(key, 0, keyStart, 0, keyStart.length);
        boolean bl = valid = KeyFile.getKeyFileIdentifier(keyStart) != null;
        if (!withoutCrcCheck) {
            long fileCrc;
            long crc = CRC.getCRC_32(key, 4);
            crcOk = crc == (fileCrc = HexTool.byteToUintBigEndian(key.length - 4, key));
        }
        return valid && (crcOk || withoutCrcCheck);
    }

    public static boolean isValidKey(File f) {
        return KeyFile.isValidKey(f, false);
    }

    public static boolean isValidKey(File f, boolean withoutCheck) {
        boolean valid;
        try {
            byte[] data = new byte[withoutCheck ? 24 : (int)f.length()];
            try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
                raf.read(data);
            }
            valid = KeyFile.isValidKey(data, withoutCheck);
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public int getCrcValue() {
        int crc = -1;
        try {
            crc = (int)CRC.getCRC_32(this.getKey(), 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crc;
    }

    public static String getKeyName(byte[] key) {
        byte[] amountBytes = new byte[2];
        System.arraycopy(key, 24, amountBytes, 0, amountBytes.length);
        byte nameLength = HexTool.parseHex(new String(amountBytes));
        byte[] nameBytes = new byte[nameLength];
        System.arraycopy(key, 26, nameBytes, 0, nameBytes.length);
        return new String(nameBytes);
    }

    public static void replacePureKey(byte[] key, byte[] pureKey) {
        int stInx = KeyFile.getKeyStartingPoint(key);
        System.arraycopy(pureKey, 0, key, stInx, pureKey.length);
        long crc = CRC.getCRC_32(key, 4);
        HexTool.insertIntBigEndianAt(crc, key.length - 4, key);
    }

    public static byte[] getPureKeyData(byte[] key) {
        byte[] amountBytes = new byte[2];
        System.arraycopy(key, 24, amountBytes, 0, amountBytes.length);
        byte nameLength = HexTool.parseHex(new String(amountBytes));
        int hLength = nameLength + 26;
        byte[] pureKey = new byte[key.length - hLength - 4];
        System.arraycopy(key, hLength, pureKey, 0, pureKey.length);
        return pureKey;
    }

    public byte[] getPureKeyData() throws Exception {
        byte[] thisKey = this.getKey();
        return KeyFile.getPureKeyData(thisKey);
    }

    public int getPureKeyDataLength() throws Exception {
        if (this.pureKeyDataLength == null) {
            this.pureKeyDataLength = this.getPureKeyData().length;
        }
        return this.pureKeyDataLength;
    }

    public static byte[] provideKeyPart(byte[] key, int start, int length) {
        byte[] pure = KeyFile.getPureKeyData(key);
        byte[] part = new byte[length];
        int pos = start;
        for (int i = 0; i < length; ++i) {
            part[i] = pure[pos];
            if (++pos != pure.length) continue;
            pos = 0;
        }
        return part;
    }

    public static int getKeyStartingPoint(byte[] key) {
        byte[] amountBytes = new byte[2];
        System.arraycopy(key, 24, amountBytes, 0, amountBytes.length);
        byte nameLength = HexTool.parseHex(new String(amountBytes));
        return 26 + nameLength;
    }

    public byte[] getKey() throws Exception {
        if (this.key == null) {
            File f = new File(this.getPath());
            this.key = new byte[(int)f.length()];
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
                in.read(this.key);
            }
        }
        return this.key;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public static String randomFileName(int length) {
        if (random == null) {
            random = new Random(System.currentTimeMillis());
        }
        String s = "";
        for (int i = 0; i < length; ++i) {
            int c = random.nextInt(15);
            s = s + (char)(c >= 10 ? c + 55 : c + 48);
        }
        return s.toLowerCase();
    }

    public String getDrive() {
        return this.driveLetter;
    }

    private static int getEntryPoint(double f, byte[] key) {
        int n = key.length;
        int entryPoint = (int)((double)(n - 1) * f) + lastEntryPointAdd + HexTool.byteToInt((byte)System.nanoTime());
        if (entryPoint > n - 1) {
            entryPoint = (entryPoint %= n) == n - 1 ? entryPoint - 1 : entryPoint;
        }
        lastEntryPointAdd = HexTool.byteToWordLittleEndian(entryPoint, key);
        return entryPoint;
    }

    public static ArrayList<Integer> getDifferentEntryPoints(double f, byte[] key, int count, ArrayList<Integer> existing) throws Exception {
        if (key.length - (existing != null ? existing.size() : 0) < count) {
            throw new Exception("Not enough entry points available.");
        }
        if (f < 0.0 || f >= 1.0) {
            throw new Exception("Random factor out of range.");
        }
        boolean linear = (double)count / (double)key.length > 0.05;
        ArrayList<Integer> entryPoints = new ArrayList<Integer>();
        int ep = KeyFile.getEntryPoint(f, key);
        while (entryPoints.size() < count) {
            ep = linear ? ep + 1 : KeyFile.getEntryPoint(f, key);
            int n = ep = ep > key.length ? 0 : ep;
            if (!linear && entryPoints.contains(ep) || (existing == null || existing.contains(ep)) && existing != null) continue;
            entryPoints.add(ep);
        }
        return entryPoints;
    }

    public static ArrayList<Integer> getDifferentEntryPoints(double f, byte[] key, int count) throws Exception {
        return KeyFile.getDifferentEntryPoints(f, key, count, null);
    }

    public static KeyFile takeAsKey(File f) {
        KeyFile keyFile = null;
        byte[] buffer = new byte[24];
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            bis.read(buffer);
            bis.close();
            Long fileId = KeyFile.getKeyFileIdentifier(buffer);
            if (fileId != null) {
                int length = (int)f.length();
                byte[] key = new byte[length];
                bis = new BufferedInputStream(new FileInputStream(f));
                bis.read(key);
                bis.close();
                if (KeyFile.isValidKey(key)) {
                    keyFile = new KeyFile(fileId, f.getAbsolutePath(), length, key);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyFile;
    }

    public void setUsedKeys(Integer used) {
        this.used = used;
    }

    public static String insertThousandsSeparators(String str) {
        String cstr = "";
        int count = 0;
        for (int i = str.length() - 1; i >= 0; --i) {
            cstr = str.charAt(i) + cstr;
            if (++count % 3 != 0 || i <= 0) continue;
            cstr = "." + cstr;
        }
        return cstr;
    }

    public static byte[] harmonicallyBalance(byte[] orgKey, double scat) {
        boolean cont;
        byte[] keyBundle = (byte[])orgKey.clone();
        byte[] bundle = KeyFile.getPureKeyData(keyBundle);
        KeyQualityAssessor kqa = new KeyQualityAssessor();
        Double[] quality = null;
        int[] frequencies = new int[256];
        int[] minMaxIndexes = new int[2];
        do {
            KeyFile.determineFrequencies(bundle, frequencies);
            KeyFile.determineMinMaxIndexes(frequencies, minMaxIndexes);
            cont = KeyFile.exchange(minMaxIndexes, frequencies, bundle);
            KeyFile.replacePureKey(keyBundle, bundle);
            quality = kqa.determineQuality(keyBundle);
        } while (cont && quality[1] < scat);
        return keyBundle;
    }

    private static void determineFrequencies(byte[] bundle, int[] frequencies) {
        int i;
        for (i = 0; i < frequencies.length; ++i) {
            frequencies[i] = 0;
        }
        for (i = 0; i < bundle.length; ++i) {
            int inx = HexTool.byteToInt(bundle[i]);
            frequencies[inx] = frequencies[inx] + 1;
        }
    }

    private static void determineMinMaxIndexes(int[] frequencies, int[] minMaxIndexes) {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int i = 1; i < frequencies.length; ++i) {
            if (frequencies[i] < min) {
                min = frequencies[i];
                minMaxIndexes[0] = i;
            }
            if (frequencies[i] <= max) continue;
            max = frequencies[i];
            minMaxIndexes[1] = i;
        }
    }

    private static boolean exchange(int[] minMaxIndexes, int[] frequencies, byte[] bundle) {
        boolean exchanged = false;
        Random random = new Random(System.nanoTime());
        int amount = (frequencies[minMaxIndexes[1]] - frequencies[minMaxIndexes[0]]) / 2;
        byte high = (byte)minMaxIndexes[1];
        byte low = (byte)minMaxIndexes[0];
        for (int j = 0; j < amount; ++j) {
            int inx = (int)(random.nextDouble(1.0) * (double)bundle.length);
            while (bundle[inx] != high) {
                inx = ++inx == bundle.length ? 0 : inx;
            }
            bundle[inx] = low;
            exchanged = true;
        }
        return exchanged;
    }

    public static Double[] calculateDiversity(byte[] pData_1, byte[] pData_2) {
        int equCount = 0;
        int dists = 0;
        for (int i = 0; i < pData_1.length; ++i) {
            if (pData_1[i] == pData_2[i]) {
                ++equCount;
            }
            dists += Math.abs(HexTool.byteToInt(pData_1[i]) - HexTool.byteToInt(pData_2[i]));
        }
        double aveDist = (double)dists / (double)pData_1.length;
        Double[] results = new Double[]{equCount, (1.0 - (double)equCount / (double)pData_1.length) * 100.0, aveDist};
        return results;
    }
}

