/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.processors;

import de.das.encrypter.model.KeyFile;
import de.das.encrypter.processors.EncoderDecoder;
import de.das.encrypter.processors.ProgressListener;

public class Assembler {
    private final int expectedSize;
    private final ProgressListener progressListener;
    private int bufferPointer = 0;
    private final byte[] data;
    private byte[] key = null;

    public Assembler(int expectedSize, ProgressListener pl) {
        this.expectedSize = expectedSize;
        this.progressListener = pl;
        this.data = new byte[expectedSize];
    }

    public void setData(byte[] fragment) {
        System.arraycopy(fragment, 0, this.data, this.bufferPointer, fragment.length);
        this.bufferPointer += fragment.length;
        if (this.progressListener != null) {
            this.progressListener.setCurrentAmount(this.bufferPointer);
        }
    }

    public boolean isValidKey() {
        boolean valid;
        boolean bl = valid = this.data.length == this.expectedSize;
        if (valid) {
            EncoderDecoder ed = new EncoderDecoder();
            try {
                this.key = ed.decrypt(this.data);
                valid = KeyFile.isValidKey(this.key);
            }
            catch (Exception e) {
                this.key = null;
                valid = false;
            }
        }
        return valid;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getData() {
        return this.data;
    }
}

