/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.processors;

import de.das.encrypter.processors.KeyTransfer;
import de.das.encrypter.processors.ProgressListener;
import de.das.encrypter.processors.Splitter;
import de.das.encrypter.processors.TransferControl;
import de.das.encrypter.tools.CRC;
import de.das.encrypter.tools.HexTool;
import javax.swing.Timer;

public class BlockSender
extends Thread {
    private final byte[] frame = new byte[16400];
    private byte[] block;
    private Splitter splitter;
    private final byte[] payload;
    private final TransferControl ctrl;
    private final Timer connectionTimeOut;

    public BlockSender(byte[] payload, ProgressListener pl, TransferControl ctrl, Timer timer) {
        this.payload = payload;
        this.ctrl = ctrl;
        this.connectionTimeOut = timer;
        this.init(pl);
    }

    private void init(ProgressListener pl) {
        this.splitter = new Splitter(this.payload, pl);
    }

    @Override
    public void run() {
        this.ctrl.setFrameId(this.splitter.getBlockCount());
        this.block = this.splitter.getNext();
        this.ctrl.setNextFrame(true);
        while (this.block != null && !this.ctrl.isBreakSender()) {
            if (this.ctrl.isNextFrame()) {
                this.buildFrame(this.ctrl.getFrameId(), this.payload.length, this.block);
            }
            this.ctrl.setWaitForResponse(true);
            this.ctrl.setResponse(false);
            this.ctrl.setNextFrame(false);
            this.ctrl.getSender().callServer(this.frame);
            this.connectionTimeOut.restart();
            this.waitForResponse();
            if (!this.ctrl.isNextFrame()) continue;
            this.ctrl.setFrameId(this.splitter.getBlockCount());
            this.block = this.splitter.getNext();
        }
        if (this.block == null && !this.ctrl.isBreakSender()) {
            this.ctrl.setWaitForResponse(true);
            this.ctrl.setResponse(false);
            this.ctrl.getSender().callServer(KeyTransfer.EOT);
            this.connectionTimeOut.restart();
            this.waitForResponse();
        }
    }

    private void buildFrame(int id, int keySize, byte[] block) {
        System.arraycopy(block, 0, this.frame, 12, block.length);
        HexTool.insertIntBigEndianAt(id, 0, this.frame);
        HexTool.insertIntBigEndianAt(keySize, 4, this.frame);
        HexTool.insertIntBigEndianAt(block.length, 8, this.frame);
        int crc = (int)CRC.getCRC_32(this.frame, 4);
        HexTool.insertIntBigEndianAt(crc, this.frame.length - 4, this.frame);
    }

    private void waitForResponse() {
        while (!this.ctrl.isResponse() && !this.ctrl.isBreakSender()) {
            try {
                BlockSender.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

