/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.processors;

import de.das.encrypter.model.InvalidKeyException;
import de.das.encrypter.model.Key;
import de.das.encrypter.model.KeyFile;
import de.das.encrypter.model.KeyFiles;
import de.das.encrypter.model.NoKeyAvailableException;
import de.das.encrypter.model.NotEncryptedException;
import de.das.encrypter.tools.CRC;
import de.das.encrypter.tools.HexTool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class EncoderDecoder {
    private static String noFolderName;
    private static KeyFiles keyFiles;

    public static void setup(KeyFiles kfs) {
        EncoderDecoder.setup("\uf030", kfs);
    }

    public static void setup(String name, KeyFiles kfs) {
        noFolderName = name;
        keyFiles = kfs;
    }

    public static String getFolderName(File f) {
        return EncoderDecoder.getFolderName(f.getAbsolutePath(), f.getName());
    }

    public static String getFolderName(String path, String lastFolder) {
        String folderName = " Error ";
        path = path.substring(0, path.indexOf(lastFolder) + lastFolder.length()) + File.separator + lastFolder;
        File nameContainerFile = new File(path);
        int len = (int)nameContainerFile.length();
        byte[] folderFileBytes = new byte[len];
        try {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(nameContainerFile));){
                in.read(folderFileBytes);
            }
            byte[] buffer = new byte[16];
            System.arraycopy(folderFileBytes, 0, buffer, 0, buffer.length);
            long keyId = Long.parseLong(new String(buffer), 16);
            KeyFile kf = (KeyFile)keyFiles.get(keyId);
            if (kf != null) {
                byte[] key = kf.getKey();
                byte[] nameBytes = new byte[folderFileBytes.length - 16];
                System.arraycopy(folderFileBytes, 16, nameBytes, 0, nameBytes.length);
                for (int i = 0; i < nameBytes.length; ++i) {
                    nameBytes[i] = (byte)(nameBytes[i] ^ key[i]);
                }
                folderName = new String(nameBytes);
            } else {
                folderName = noFolderName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (folderName.contains("Error")) {
            // empty if block
        }
        return folderName;
    }

    public long getKeyId(File f) throws Exception, NotEncryptedException {
        byte[] content = new byte[40];
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            bis.read(content);
        }
        return EncoderDecoder.getKeyId(content);
    }

    public static long getKeyId(byte[] content) throws Exception, NotEncryptedException {
        if (EncoderDecoder.isEncrypted(content)) {
            byte[] buffer = new byte[16];
            System.arraycopy(content, 6, buffer, 0, buffer.length);
            long keyId = Long.parseLong(new String(buffer), 16);
            return keyId;
        }
        throw new NotEncryptedException();
    }

    public static long getKeyEntryPoint(File f) throws Exception {
        byte[] buffer = new byte[48];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            in.read(buffer);
        }
        return EncoderDecoder.getKeyEntryPoint(buffer);
    }

    public static long getKeyEntryPoint(byte[] content) throws Exception {
        byte[] buffer = new byte[16];
        System.arraycopy(content, 22, buffer, 0, buffer.length);
        String eStr = new String(buffer);
        while (eStr.startsWith("0") && eStr.length() > 1) {
            eStr = eStr.substring(1);
        }
        long entry = Long.parseLong(eStr, 16);
        return entry;
    }

    public byte[] decrypt(byte[] data) throws NoKeyAvailableException, Exception {
        byte[] dcontent = null;
        long keyId = EncoderDecoder.getKeyId(data);
        KeyFile keyFile = (KeyFile)keyFiles.get(keyId);
        if (keyFile == null) {
            throw new NoKeyAvailableException();
        }
        byte[] key = keyFile.getKey();
        dcontent = this.decrypt(key, data);
        return dcontent;
    }

    public byte[] decrypt(byte[] key, byte[] data) throws Exception {
        if (data.length < 40) {
            throw new Exception("File length too less.");
        }
        byte[] pureKey = KeyFile.getPureKeyData(key);
        long entry = EncoderDecoder.getKeyEntryPoint(data);
        byte[] nameBytes = EncoderDecoder.getEncryptedFileName(data);
        byte[] content = new byte[data.length - (42 + nameBytes.length)];
        System.arraycopy(data, 42 + nameBytes.length, content, 0, content.length);
        int pointer = (int)entry;
        for (int inx = 0; inx < content.length; ++inx) {
            if (pointer >= pureKey.length) {
                pointer = 0;
            }
            content[inx] = (byte)(content[inx] ^ pureKey[pointer]);
            ++pointer;
        }
        return content;
    }

    public byte[] encrypt(long entryPoint, byte[] key, byte[] data) throws InvalidKeyException, Exception {
        return this.encrypt(entryPoint, key, data, null);
    }

    public byte[] encrypt(long entryPoint, byte[] key, byte[] data, String fileName) throws InvalidKeyException, Exception {
        byte[] pureKey = KeyFile.getPureKeyData(key);
        byte[] nameBytes = fileName == null ? new byte[]{} : fileName.getBytes();
        int upPointer = (int)entryPoint;
        for (int inx = 0; inx < nameBytes.length; ++inx) {
            if (upPointer >= pureKey.length) {
                upPointer = 0;
            }
            nameBytes[inx] = (byte)(nameBytes[inx] ^ pureKey[upPointer]);
            ++upPointer;
        }
        byte[] signatureBytes = new byte["KEYFILE_".length()];
        System.arraycopy(key, 0, signatureBytes, 0, signatureBytes.length);
        String signature = new String(signatureBytes);
        if (!signature.equals("KEYFILE_")) {
            throw new InvalidKeyException();
        }
        byte[] encryptionFixPart = new byte[40];
        byte[] encryptionPrefix = new byte[40 + nameBytes.length + 2];
        System.arraycopy("@@&&$$".getBytes(), 0, encryptionFixPart, 0, Key.ENCRYPTION_ID_LENGTH);
        System.arraycopy(key, "KEYFILE_".length(), encryptionFixPart, 6, 16);
        System.arraycopy(HexTool.toTwoHexQuad((int)(entryPoint >> 32 & 0xFFFFFFFFFFFFFFFFL)).getBytes(), 0, encryptionFixPart, 22, 8);
        System.arraycopy(HexTool.toTwoHexQuad((int)(entryPoint & 0xFFFFFFFFFFFFFFFFL)).getBytes(), 0, encryptionFixPart, 30, 8);
        int crc = CRC.getCRC_16(encryptionFixPart, 2);
        HexTool.insertShortIntLittleEndianAt(crc, 38, encryptionFixPart);
        System.arraycopy(encryptionFixPart, 0, encryptionPrefix, 0, encryptionFixPart.length);
        HexTool.insertShortIntLittleEndianAt(nameBytes.length, 40, encryptionPrefix);
        System.arraycopy(nameBytes, 0, encryptionPrefix, 42, nameBytes.length);
        byte[] econtent = new byte[data.length + encryptionPrefix.length];
        System.arraycopy(encryptionPrefix, 0, econtent, 0, encryptionPrefix.length);
        int offset = encryptionPrefix.length;
        try {
            upPointer = (int)entryPoint;
            for (int inx = 0; inx < data.length; ++inx) {
                if (upPointer >= pureKey.length) {
                    upPointer = 0;
                }
                econtent[inx + offset] = (byte)(data[inx] ^ pureKey[upPointer]);
                ++upPointer;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return econtent;
    }

    public byte[] encrypt(long keyId, byte[] pureKey, long entryPoint, byte[] data, String fileName) throws InvalidKeyException, Exception {
        byte[] nameBytes = fileName == null ? new byte[]{} : fileName.getBytes();
        int upPointer = (int)entryPoint;
        for (int inx = 0; inx < nameBytes.length; ++inx) {
            if (upPointer >= pureKey.length) {
                upPointer = 0;
            }
            nameBytes[inx] = (byte)(nameBytes[inx] ^ pureKey[upPointer]);
            ++upPointer;
        }
        byte[] encryptionFixPart = new byte[40];
        byte[] encryptionPrefix = new byte[42 + nameBytes.length];
        System.arraycopy("@@&&$$".getBytes(), 0, encryptionFixPart, 0, Key.ENCRYPTION_ID_LENGTH);
        String hexId = HexTool.toTwoHexQuad((int)(keyId >> 32 & 0xFFFFFFFFFFFFFFFFL)) + HexTool.toTwoHexQuad((int)(keyId & 0xFFFFFFFFFFFFFFFFL));
        System.arraycopy(hexId.getBytes(), 0, encryptionFixPart, 6, 16);
        System.arraycopy(HexTool.toTwoHexQuad((int)(entryPoint >> 32 & 0xFFFFFFFFFFFFFFFFL)).getBytes(), 0, encryptionFixPart, 22, 8);
        System.arraycopy(HexTool.toTwoHexQuad((int)(entryPoint & 0xFFFFFFFFFFFFFFFFL)).getBytes(), 0, encryptionFixPart, 30, 8);
        int crc = CRC.getCRC_16(encryptionFixPart, 2);
        HexTool.insertShortIntLittleEndianAt(crc, 38, encryptionFixPart);
        System.arraycopy(encryptionFixPart, 0, encryptionPrefix, 0, encryptionFixPart.length);
        HexTool.insertShortIntLittleEndianAt(nameBytes.length, 40, encryptionPrefix);
        System.arraycopy(nameBytes, 0, encryptionPrefix, 42, nameBytes.length);
        byte[] econtent = new byte[data.length + encryptionPrefix.length];
        System.arraycopy(encryptionPrefix, 0, econtent, 0, encryptionPrefix.length);
        int offset = encryptionPrefix.length;
        try {
            upPointer = 0;
            for (int inx = 0; inx < data.length; ++inx) {
                if (upPointer >= pureKey.length) {
                    upPointer = 0;
                }
                econtent[inx + offset] = (byte)(data[inx] ^ pureKey[upPointer]);
                ++upPointer;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return econtent;
    }

    public byte[] getKeyById(String folder, long keyId) {
        File[] files;
        byte[] key = null;
        byte[] idBytes = new byte[16];
        for (File f : files = new File(folder).listFiles()) {
            if (f.length() <= (long)("KEYFILE_".length() + 16)) continue;
            try {
                byte[] keySignature = new byte["KEYFILE_".length() + 16];
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                bis.read(keySignature);
                bis.close();
                System.arraycopy(keySignature, 8, idBytes, 0, idBytes.length);
                long checkId = Long.parseLong(new String(idBytes), 16);
                if (checkId == keyId) {
                    key = new byte[(int)f.length()];
                    bis = new BufferedInputStream(new FileInputStream(f));
                    bis.read(key);
                    bis.close();
                }
                if (key == null) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return key;
    }

    public static boolean isEncrypted(byte[] buffer) {
        byte[] id = new byte[Key.ENCRYPTION_ID_LENGTH];
        System.arraycopy(buffer, 0, id, 0, id.length);
        boolean ok = Arrays.equals(id, "@@&&$$".getBytes());
        return ok;
    }

    public boolean isEncrypted(File f) throws Exception {
        byte[] buffer = new byte[40];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            in.read(buffer);
        }
        return EncoderDecoder.isEncrypted(buffer);
    }

    public static String getFileName(String path) {
        String name = null;
        try {
            byte[] first = new byte[42];
            RandomAccessFile raf = new RandomAccessFile(new File(path), "r");
            raf.read(first);
            raf.close();
            short nameLength = HexTool.byteToShortIntLittleEndian(40, first);
            byte[] fullPrefix = new byte[42 + nameLength];
            raf = new RandomAccessFile(new File(path), "r");
            raf.read(fullPrefix);
            raf.close();
            name = EncoderDecoder.getDecryptedFileName(fullPrefix);
        }
        catch (Exception e) {
            name = null;
        }
        return name;
    }

    public static String getDecryptedFileName(byte[] econtent) throws Exception {
        byte[] nameBytes = EncoderDecoder.getEncryptedFileName(econtent);
        long entry = EncoderDecoder.getKeyEntryPoint(econtent);
        long keyId = EncoderDecoder.getKeyId(econtent);
        byte[] key = ((KeyFile)keyFiles.get(keyId)).getPureKeyData();
        int pointer = (int)entry;
        for (int inx = 0; inx < nameBytes.length; ++inx) {
            if (pointer >= key.length) {
                pointer = 0;
            }
            nameBytes[inx] = (byte)(nameBytes[inx] ^ key[pointer]);
            ++pointer;
        }
        return new String(nameBytes);
    }

    public static byte[] getEncryptedFileName(byte[] econtent) {
        short nameLength = HexTool.byteToShortIntLittleEndian(40, econtent);
        byte[] nameBytes = new byte[nameLength];
        System.arraycopy(econtent, 42, nameBytes, 0, nameLength);
        return nameBytes;
    }

    public byte[] getPureEncryptedData(byte[] eData) throws Exception {
        if (!EncoderDecoder.isEncrypted(eData)) {
            throw new Exception("Not encrypted.");
        }
        short nameLength = HexTool.byteToShortIntLittleEndian(40, eData);
        int pureDataSize = eData.length - (42 + nameLength);
        byte[] pure = new byte[pureDataSize];
        System.arraycopy(eData, 42 + nameLength, pure, 0, pure.length);
        return pure;
    }

    static {
        keyFiles = null;
    }
}

