/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.processors;

import de.das.encrypter.model.KeyFile;
import de.das.encrypter.model.KeyFileLocation;
import de.das.encrypter.model.KeyFiles;
import de.das.encrypter.model.KeyFilesSearchReceiver;
import de.das.encrypter.tools.BaseThread;
import de.das.encrypter.tools.HiddenDataTool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class KeyFilesSearcher
extends BaseThread {
    private static final int PERIOD = 10;
    private boolean active = false;
    private static KeyFilesSearcher searcher;
    private final KeyFilesSearchReceiver searchReceiver;
    private final HiddenDataTool hdt = new HiddenDataTool();

    public static void createInstance(KeyFilesSearchReceiver searchReceiver) {
        KeyFilesSearcher.createInstance(searchReceiver, 10);
    }

    public static void createInstance(KeyFilesSearchReceiver searchReceiver, int period) {
        if (searcher == null) {
            searcher = new KeyFilesSearcher(searchReceiver, period * 1000);
            searcher.start();
        }
    }

    private KeyFilesSearcher(KeyFilesSearchReceiver searchReceiver, int period) {
        this.searchReceiver = searchReceiver;
        this.setSleepTime(period);
        this.init();
    }

    private void init() {
        this.setName("Key files searcher");
    }

    @Override
    public void doTask() {
        if (!this.active && this.searchReceiver.isSearchingAllowed()) {
            this.active = true;
            this.search();
            this.active = false;
        }
    }

    private void search() {
        ArrayList<String> secretContainers;
        this.searchReceiver.setKeyFileSearching(true);
        ArrayList<KeyFileLocation> keyFileLocations = new ArrayList<KeyFileLocation>();
        KeyFiles files = new KeyFiles();
        ArrayList<File> bundleFolders = this.searchForBundle();
        this.searchReceiver.setBundleFolders(bundleFolders);
        if (!bundleFolders.isEmpty()) {
            for (File bundleFolder : bundleFolders) {
                File[] content = bundleFolder.listFiles();
                byte[] buffer = new byte[24];
                if (content == null) continue;
                for (File f : content) {
                    try {
                        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                        bis.read(buffer);
                        bis.close();
                        Long fileId = KeyFile.getKeyFileIdentifier(buffer);
                        if (fileId == null) continue;
                        int length = (int)f.length();
                        byte[] key = new byte[length];
                        bis = new BufferedInputStream(new FileInputStream(f));
                        bis.read(key);
                        bis.close();
                        if (!KeyFile.isValidKey(key)) continue;
                        files.put(fileId, new KeyFile((long)fileId, f.getAbsolutePath(), length));
                        keyFileLocations.add(new KeyFileLocation(KeyFile.getKeyName(key), fileId, f.getAbsolutePath()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (!(secretContainers = this.searchForSecretContainers()).isEmpty()) {
            for (String drive : secretContainers) {
                this.searchForHiddenKeys(drive, new File(drive), files, keyFileLocations);
            }
        }
        this.updateKeyFilesList(this.searchReceiver.getKeyFiles());
        this.searchReceiver.synchronizeKeyFilesList(files);
        this.searchReceiver.setKeyFileLocations(keyFileLocations);
        this.searchReceiver.setKeyFileSearching(false);
    }

    private ArrayList<String> searchForSecretContainers() {
        ArrayList<String> foundFiles = new ArrayList<String>();
        char[] root = new char[]{'C'};
        while (root[0] <= 'Z') {
            String rootStr = new String(root) + ":\\" + "a45f210b4cd22af";
            File f = new File(rootStr);
            if (f.exists()) {
                try {
                    byte[] buffer = new byte["($%%$)31#909#".getBytes().length];
                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
                        in.read(buffer);
                    }
                    if (Arrays.equals(buffer, "($%%$)31#909#".getBytes())) {
                        foundFiles.add(new String(root) + ":\\");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            root[0] = (char)(root[0] + '\u0001');
        }
        return foundFiles;
    }

    private ArrayList<File> searchForBundle() {
        ArrayList<File> foundFiles = new ArrayList<File>();
        char[] root = new char[]{'C'};
        while (root[0] <= 'Z') {
            File[] files;
            String rootStr = new String(root) + ":\\";
            File f = new File(rootStr);
            if (f.exists() && (files = f.listFiles()) != null) {
                for (File ff : files) {
                    if (!ff.isDirectory() || !ff.getName().equals(KeyFiles.FOLDER_NAME)) continue;
                    foundFiles.add(ff);
                }
            }
            root[0] = (char)(root[0] + '\u0001');
        }
        return foundFiles;
    }

    private void updateKeyFilesList(KeyFiles keyFiles) {
        for (Long id : keyFiles.keySet().toArray(new Long[0])) {
            KeyFile keyFile = (KeyFile)keyFiles.get(id);
            if (keyFile.getPath() != null && !new File(keyFile.getPath()).exists()) {
                keyFiles.remove(id);
            }
            if (keyFile.getPath() != null || new File(keyFile.getDrive()).exists()) continue;
            keyFiles.remove(id);
        }
    }

    private void searchForHiddenKeys(String drive, File root, KeyFiles files, ArrayList<KeyFileLocation> keyFileLocations) {
        File[] list = root.listFiles();
        if (list != null) {
            for (File f : list) {
                if (f.isDirectory()) {
                    this.searchForHiddenKeys(drive, f, files, keyFileLocations);
                    continue;
                }
                try {
                    long id;
                    byte[] key;
                    if (f.getName().toLowerCase().endsWith(".wav") && this.hdt.keyInWav(f)) {
                        key = this.hdt.byteArrayFromWav(f);
                        if (!KeyFile.isValidKey(key)) continue;
                        id = KeyFile.getKeyFileIdentifier(key);
                        files.put(id, new KeyFile(id, key, drive));
                        keyFileLocations.add(new KeyFileLocation(KeyFile.getKeyName(key), id, f.getAbsolutePath()));
                        continue;
                    }
                    if (!f.getName().toLowerCase().endsWith(".png") || !this.hdt.keyInPng(f) && !this.hdt.keyInQr(f)) continue;
                    key = this.hdt.byteArrayFromQr(f);
                    if (key != null) {
                        if (!KeyFile.isValidKey(key)) continue;
                        id = KeyFile.getKeyFileIdentifier(key);
                        files.put(id, new KeyFile(id, key, drive));
                        keyFileLocations.add(new KeyFileLocation(KeyFile.getKeyName(key), id, f.getAbsolutePath()));
                        continue;
                    }
                    key = this.hdt.byteArrayFromImg(f);
                    if (key == null || !KeyFile.isValidKey(key)) continue;
                    id = KeyFile.getKeyFileIdentifier(key);
                    files.put(id, new KeyFile(id, key, drive));
                    keyFileLocations.add(new KeyFileLocation(KeyFile.getKeyName(key), id, f.getAbsolutePath()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

