/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.processors;

import de.das.encrypter.processors.RandomFactorReceiver;
import de.das.encrypter.tools.BaseThread;
import de.das.encrypter.tools.HexTool;
import java.util.Random;

public class RandomFactorGenerator
extends BaseThread {
    private Random random;
    private final RandomFactorReceiver randomFactorReceiver;
    private final byte[] randomInt = new byte[8];
    private int randomValue = 0;
    private final int intMax = Integer.MAX_VALUE;
    private static RandomFactorGenerator rfg;

    public static void createInstance(RandomFactorReceiver rfr) {
        rfg = new RandomFactorGenerator(rfr);
        rfg.start();
    }

    public RandomFactorGenerator(RandomFactorReceiver rfr) {
        this.randomFactorReceiver = rfr;
        this.init();
    }

    private void init() {
        this.setSleepTime(100L);
        this.setName("Random Factor Generator");
        this.random = new Random(System.currentTimeMillis());
    }

    private void nextRandom() {
        this.random.nextBytes(this.randomInt);
        this.randomInt[7] = (byte)(this.randomInt[7] & 0x7F);
        int additional = HexTool.byteToInt(this.randomInt);
        this.randomValue += additional;
        this.randomValue = this.randomValue < 0 ? -this.randomValue : this.randomValue;
    }

    @Override
    public void doTask() {
        this.nextRandom();
        this.randomFactorReceiver.setRandomFactor((double)this.randomValue / 2.147483647E9);
    }
}

