/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.processors;

import de.das.encrypter.processors.ProgressListener;

public class Splitter {
    private byte[] buffer = new byte[16384];
    private final byte[] data;
    private final ProgressListener progressListener;
    private int currentCount = 0;
    private int blockCount = 0;

    public Splitter(byte[] data, ProgressListener pl) {
        this.data = data;
        this.progressListener = pl;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public byte[] getNext() {
        if (this.currentCount == this.data.length) {
            return null;
        }
        if (this.data.length - this.currentCount < this.buffer.length) {
            this.buffer = new byte[this.data.length - this.currentCount];
        }
        System.arraycopy(this.data, this.currentCount, this.buffer, 0, this.buffer.length);
        this.currentCount += this.buffer.length;
        if (this.progressListener != null) {
            this.progressListener.setCurrentAmount(this.currentCount);
        }
        ++this.blockCount;
        return this.buffer;
    }
}

