/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.processors;

import de.das.encrypter.comm.DataReceiver;
import de.das.encrypter.comm.UdpSender;
import de.das.encrypter.processors.KeyTransfer;
import de.das.encrypter.processors.ResultReceiver;
import de.das.encrypter.tools.HexTool;
import java.util.Arrays;

public class TransferControl
implements DataReceiver {
    public static final String PARTNER_ID = "Hello partner:";
    public static final String PARTNER_RESPONSE = "Ready:";
    public static final String TRANSFER_BREAK = "Break";
    public static final int NO_RESULT = -1;
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    private UdpSender sender;
    private int frameId;
    private boolean response;
    private boolean waitForResponse;
    private boolean nextFrame;
    private boolean breakSender;
    private boolean waitingForInfo;
    private final ResultReceiver results;
    private int transferResult;

    public TransferControl(ResultReceiver rr) {
        this.results = rr;
        this.init();
    }

    public void setupSender(String host, int port) throws Exception {
        this.sender = new UdpSender("Transfer Control", host, port);
    }

    private void init() {
    }

    public void setHost(String host, int port) throws Exception {
        this.setupSender(host, port);
    }

    public boolean isResponse() {
        return this.response;
    }

    public void setResponse(boolean response) {
        this.response = response;
    }

    public boolean isWaitForResponse() {
        return this.waitForResponse;
    }

    public void setWaitForResponse(boolean waitForResponse) {
        this.waitForResponse = waitForResponse;
    }

    public boolean isNextFrame() {
        return this.nextFrame;
    }

    public void setNextFrame(boolean nextFrame) {
        this.nextFrame = nextFrame;
    }

    public int getFrameId() {
        return this.frameId;
    }

    public void setFrameId(int frameId) {
        this.frameId = frameId;
    }

    public boolean isBreakSender() {
        return this.breakSender;
    }

    public void setBreakSender(boolean breakSender) {
        this.breakSender = breakSender;
    }

    public UdpSender getSender() {
        return this.sender;
    }

    public boolean isWaitingForInfo() {
        return this.waitingForInfo;
    }

    public void setWaitingForInfo(boolean b) {
        this.waitingForInfo = b;
    }

    @Override
    public void setData(String host, byte[] bytes) {
        this.setData(bytes);
    }

    @Override
    public void setData(byte[] data) {
        if (this.waitingForInfo) {
            if (new String(data).startsWith(PARTNER_RESPONSE)) {
                String info = new String(data).substring(PARTNER_RESPONSE.length());
                this.breakSender = true;
                this.results.setResult(0, info);
            }
            this.waitingForInfo = false;
        } else if (this.isWaitForResponse()) {
            if (data.length == KeyTransfer.FAIL.length && Arrays.equals(data, KeyTransfer.FAIL)) {
                this.results.setResult(1, null);
            }
            if (data.length == KeyTransfer.VALID.length && Arrays.equals(data, KeyTransfer.VALID)) {
                this.results.setResult(2, null);
            }
            if (data.length == TRANSFER_BREAK.length() && new String(data).equals(TRANSFER_BREAK)) {
                this.results.setResult(3, null);
            } else if (data.length == 4 && HexTool.byteToInt(data) == this.getFrameId()) {
                this.setNextFrame(true);
            }
            this.setResponse(true);
        }
    }

    public void setTransferResult(int res) {
        this.transferResult = res;
    }

    public int getTransferResult() {
        return this.transferResult;
    }
}

