/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

public abstract class BaseThread
extends Thread {
    public long threadID = 0L;
    private boolean killed = false;
    private boolean m_bTerminated = false;
    private long sleepTimeMin = 0L;
    private long sleepTimeMax = 172800000L;
    private long sleepTime = 20L;

    public long getThreadID() {
        return this.threadID;
    }

    @Override
    public void run() {
        this.prolog();
        while (!this.killed) {
            this.doTask();
            try {
                BaseThread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.finish();
    }

    public abstract void doTask();

    public void prolog() {
    }

    public void finish() {
        this.m_bTerminated = true;
    }

    public synchronized void setSleepTime(long t) {
        if (t >= this.sleepTimeMin && t <= this.sleepTimeMax) {
            this.sleepTime = t;
        }
    }

    public synchronized long getSleepTime() {
        return this.sleepTime;
    }

    public synchronized void setSleepTimeMin(long t) {
        if (t >= 10L && t <= this.sleepTimeMax) {
            this.sleepTime = t;
        }
    }

    public synchronized void setSleepTimeMax(long t) {
        if (t >= 10L && t >= this.sleepTimeMin) {
            this.sleepTime = t;
        }
    }

    public synchronized void kill() {
        if (!this.killed) {
            this.killed = true;
            this.interrupt();
        }
    }

    public boolean isKilled() {
        return this.killed;
    }

    public boolean isTerminated() {
        return this.m_bTerminated;
    }
}

