/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

import java.io.File;
import java.io.RandomAccessFile;

public class BufferedByteArray {
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private static final int MINIMUM_BUFFER_SIZE = 32;
    private static final int MAXIMUM_BUFFER_SIZE = 0xA00000;
    private byte[] buffer;
    RandomAccessFile dataFile;
    private int maxBufferPosition;
    private int block;
    private long bufferedByteArraySize;
    private boolean dataChanges = false;

    public BufferedByteArray(File f) throws Exception {
        this(f, 0x100000);
    }

    public BufferedByteArray(File f, int bufferSize) throws Exception {
        this.dataFile = new RandomAccessFile(f, "rw");
        this.init(bufferSize);
    }

    private void init(int bufferSize) throws Exception {
        if (bufferSize < 32 || bufferSize > 0xA00000) {
            throw new Exception("Invalid buffer size");
        }
        this.bufferedByteArraySize = this.dataFile.length();
        this.buffer = new byte[bufferSize];
        this.block = 0;
        this.maxBufferPosition = 0;
        if (this.dataFile.length() > 0L) {
            this.maxBufferPosition = this.dataFile.read(this.buffer);
        }
    }

    public byte getByteAt(int position) throws Exception {
        if ((long)position >= this.bufferedByteArraySize) {
            throw new Exception("Index out of range.");
        }
        int neededBlock = position / this.buffer.length;
        int pointer = position % this.buffer.length;
        if (neededBlock != this.block) {
            if (this.dataChanges) {
                this.dataFile.write(this.buffer, this.block * this.buffer.length, this.maxBufferPosition);
            }
            this.dataFile.seek(neededBlock * this.buffer.length);
            this.maxBufferPosition = this.dataFile.read(this.buffer);
            this.block = neededBlock;
        }
        return this.buffer[pointer];
    }

    public long size() {
        return this.bufferedByteArraySize;
    }

    public void arrayCopy(int pos, byte[] target, int targetPos, int length) throws Exception {
        boolean fail = false;
        if ((long)(pos + length) > this.bufferedByteArraySize || targetPos + length > target.length) {
            fail = true;
        }
        if (fail) {
            throw new Exception("Boundary violation at one of the involved byte arrays.");
        }
        int neededBlock = pos / this.buffer.length;
        if (neededBlock != this.block) {
            if (this.dataChanges) {
                this.dataFile.write(this.buffer, this.block * this.buffer.length, this.maxBufferPosition);
            }
            this.dataFile.seek(neededBlock * this.buffer.length);
            this.maxBufferPosition = this.dataFile.read(this.buffer);
            this.block = neededBlock;
        }
        int end = pos + length;
        while (pos < end) {
            int relPos = pos % this.buffer.length;
            if (end - pos < this.maxBufferPosition) {
                System.arraycopy(this.buffer, relPos, target, targetPos, end - pos);
                end = pos;
                continue;
            }
            System.arraycopy(this.buffer, relPos, target, targetPos, this.buffer.length - relPos);
            pos += this.buffer.length - relPos;
            targetPos += this.buffer.length - relPos;
            relPos = 0;
            ++this.block;
            this.maxBufferPosition = this.dataFile.read(this.buffer);
        }
    }
}

