/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

import de.das.encrypter.tools.CRC;
import de.das.encrypter.tools.HexTool;

public class ByteArrayConverter {
    public static final String IDENTIFIER = "##@@";

    public String byteArrayToString(byte[] data) throws Exception {
        String s = IDENTIFIER;
        int crc = (int)CRC.getCRC_32(data);
        byte[] dataPlus = new byte[data.length + 4];
        System.arraycopy(data, 0, dataPlus, 0, data.length);
        HexTool.insertIntLittleEndianAt(crc, dataPlus.length - 4, dataPlus);
        int tableSize = dataPlus.length / 7;
        tableSize = dataPlus.length % 7 == 0 ? tableSize : tableSize + 1;
        byte[] msbTable = new byte[tableSize];
        int bytePointer = 0;
        int bitMask = 64;
        for (int pointer = 0; pointer < dataPlus.length; ++pointer) {
            if (dataPlus[pointer] < 0) {
                dataPlus[pointer] = (byte)(dataPlus[pointer] & 0x7F);
                msbTable[bytePointer] = (byte)(msbTable[bytePointer] | bitMask);
            }
            if ((bitMask = (int)((byte)(bitMask >> 1))) != 0) continue;
            bitMask = 64;
            ++bytePointer;
        }
        s = s + this.extend(dataPlus.length, 4) + new String(dataPlus) + new String(msbTable);
        return s;
    }

    private String extend(int i, int len) {
        String s = Integer.toString(i);
        while (s.length() < 4) {
            s = "0" + s;
        }
        return s;
    }

    public byte[] stringToByteArray(String str) throws Exception {
        if (!str.startsWith(IDENTIFIER)) {
            throw new Exception("No binaries.");
        }
        str = str.substring(IDENTIFIER.length());
        int bytePlusLength = Integer.parseInt(str.substring(0, 4));
        str = str.substring(4);
        byte[] stringByte = str.getBytes();
        byte[] dataPlus = new byte[bytePlusLength];
        System.arraycopy(stringByte, 0, dataPlus, 0, dataPlus.length);
        byte[] msbTable = new byte[stringByte.length - bytePlusLength];
        System.arraycopy(stringByte, dataPlus.length, msbTable, 0, msbTable.length);
        int bytePointer = 0;
        int bitMask = 64;
        for (int pointer = 0; pointer < dataPlus.length; ++pointer) {
            if ((msbTable[bytePointer] & bitMask) != 0) {
                dataPlus[pointer] = (byte)(dataPlus[pointer] | 0x80);
            }
            if ((bitMask = (int)((byte)(bitMask >> 1))) != 0) continue;
            bitMask = 64;
            ++bytePointer;
        }
        byte[] data = new byte[dataPlus.length - 4];
        System.arraycopy(dataPlus, 0, data, 0, data.length);
        int crc = HexTool.byteToIntLittleEndian(bytePlusLength - 4, dataPlus);
        int crcCalc = (int)CRC.getCRC_32(data);
        if (crc != crcCalc) {
            throw new Exception("Conversion CRC error.");
        }
        return data;
    }
}

