/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

import de.das.encrypter.processors.ProgressListener;
import de.das.encrypter.tools.ByteArrayEncloser;
import de.das.encrypter.tools.HexTool;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class ByteArrayImgEncloser
extends ByteArrayEncloser {
    private static int instanceCounter = 0;
    private final int[] RGB_MASK = new int[]{1, 256, 65536};
    private ProgressListener listener = null;
    private final int thisInstance;
    private boolean breakIt;

    public ByteArrayImgEncloser() {
        this(null);
    }

    public ByteArrayImgEncloser(ProgressListener pl) {
        this.listener = pl;
        this.thisInstance = ++instanceCounter;
    }

    public boolean canHold(int length, File f) throws IOException {
        BufferedImage img = ImageIO.read(f);
        return this.canHold(length, img);
    }

    public boolean canHold(int length, BufferedImage img) {
        return length + 4 + ID.length <= this.getCapacity(img);
    }

    public int getCapacity(BufferedImage img) {
        int fileCapacity = img.getHeight() * img.getWidth() * 3 / 8;
        return fileCapacity;
    }

    public void hideData(byte[] d, BufferedImage img) throws Exception {
        byte[] data = new byte[d.length + 4 + ID.length];
        System.arraycopy(d, 0, data, 4 + ID.length, d.length);
        if (!this.canHold(d.length, img)) {
            throw new Exception("Image not large enough.");
        }
        System.arraycopy(ID, 0, data, 0, ID.length);
        HexTool.insertIntLittleEndianAt(d.length, ID.length, data);
        this.writeBits(img, data);
    }

    private void writeBits(BufferedImage img, byte[] data) {
        this.breakIt = false;
        int x = 0;
        int y = 0;
        int cp = 0;
        int rgb = img.getRGB(x, y);
        for (int i = 0; i < data.length && !this.breakIt; ++i) {
            byte b = data[i];
            int mask = 128;
            for (int bitPointer = 0; bitPointer < 8; ++bitPointer) {
                rgb = (b & mask) != 0 ? (rgb |= this.RGB_MASK[cp]) : (rgb &= ~this.RGB_MASK[cp]);
                mask >>= 1;
                if (++cp != 3) continue;
                img.setRGB(x, y, rgb);
                cp = 0;
                if (++x == img.getWidth()) {
                    x = 0;
                    ++y;
                }
                rgb = img.getRGB(x, y);
            }
            if (this.listener == null || i % 128 != 0) continue;
            this.listener.setCurrentAmount(i);
        }
        if (this.listener != null) {
            this.listener.setCurrentAmount(data.length);
        }
        img.setRGB(x, y, rgb);
    }

    public byte[] assemble(BufferedImage img, int count) throws Exception {
        return this.assemble(img, count, false);
    }

    public byte[] assemble(BufferedImage img, int count, boolean progress) throws Exception {
        this.breakIt = false;
        byte[] data = new byte[count];
        int x = 0;
        int y = 0;
        int cp = 0;
        int rgb = img.getRGB(x, y);
        for (int pointer = 0; pointer < count && !this.breakIt; ++pointer) {
            int mask = 128;
            byte b = 0;
            for (int bitPointer = 0; bitPointer < 8; ++bitPointer) {
                b = (rgb & this.RGB_MASK[cp]) != 0 ? (byte)(b | mask) : (byte)(b & ~mask);
                mask >>= 1;
                if (++cp != 3) continue;
                cp = 0;
                if (++x == img.getWidth()) {
                    x = 0;
                    ++y;
                }
                rgb = img.getRGB(x, y);
            }
            data[pointer] = b;
            if (this.listener == null || !progress || pointer % 128 != 0) continue;
            this.listener.setCurrentAmount(pointer);
        }
        if (this.listener != null && progress) {
            this.listener.setCurrentAmount(count);
        }
        return data;
    }

    public boolean containsHiddenData(File f) throws IOException, Exception {
        BufferedImage img = ImageIO.read(f);
        return this.containsHiddenData(img);
    }

    public boolean containsHiddenFile(File f) throws Exception {
        boolean contains = this.containsHiddenData(f);
        if (contains) {
            BufferedImage img = ImageIO.read(f);
            byte[] hfHeader = this.assemble(img, ID.length + 4 + HIDDEN_FILE_ID.length + 2);
            byte[] hfId = new byte[4];
            System.arraycopy(hfHeader, ID.length + 4, hfId, 0, hfId.length);
            if (!Arrays.equals(hfId, HIDDEN_FILE_ID)) {
                contains = false;
            }
        }
        return contains;
    }

    public void hideData(byte[] data, File f) throws Exception {
        String format = f.getName();
        format = format.substring(format.lastIndexOf(".") + 1).toUpperCase();
        BufferedImage imgx = ImageIO.read(f);
        BufferedImage img = new BufferedImage(imgx.getWidth(), imgx.getHeight(), 2);
        img.getGraphics().drawImage(imgx, 0, 0, null);
        this.hideData(data, img);
        if (!this.breakIt) {
            ImageIO.write((RenderedImage)img, format, f);
        } else {
            this.clear(f);
        }
    }

    public boolean containsHiddenData(BufferedImage img) throws Exception {
        byte[] header = this.assemble(img, ID.length + 4);
        byte[] id = new byte[ID.length];
        System.arraycopy(header, 0, id, 0, id.length);
        return Arrays.equals(ID, id);
    }

    public byte[] regainData(File f) throws IOException, Exception {
        BufferedImage img = ImageIO.read(f);
        return this.regainData(img);
    }

    public byte[] regainData(BufferedImage img) throws Exception {
        byte[] data = null;
        if (this.containsHiddenData(img)) {
            byte[] header = this.assemble(img, ID.length + 4);
            int length = HexTool.byteToIntLittleEndian(ID.length, header);
            data = new byte[length];
            byte[] imgData = this.assemble(img, length + header.length, true);
            System.arraycopy(imgData, header.length, data, 0, data.length);
        }
        return data;
    }

    public int getHiddenArraySize(File f) throws Exception {
        BufferedImage img = ImageIO.read(f);
        int length = 0;
        byte[] header = this.assemble(img, ID.length + 4);
        length = HexTool.byteToIntLittleEndian(ID.length, header);
        return length;
    }

    public void clear(File f) throws IOException {
        byte[] CLEAR = new byte[]{0, 0, 0, 0};
        BufferedImage img = ImageIO.read(f);
        this.writeBits(img, CLEAR);
        ImageIO.write((RenderedImage)img, "PNG", f);
    }

    public void breakIt() {
        this.breakIt = true;
    }

    public String getHiddenFileName(File f) throws IOException, Exception {
        BufferedImage img = ImageIO.read(f);
        byte[] prePart = this.assemble(img, ID.length + 4 + HIDDEN_FILE_ID.length + 2);
        short length = HexTool.byteToShortIntLittleEndian(ID.length + 4 + HIDDEN_FILE_ID.length, prePart);
        byte[] beginning = this.assemble(img, ID.length + 4 + HIDDEN_FILE_ID.length + 2 + length);
        byte[] nameBytes = new byte[length];
        System.arraycopy(beginning, ID.length + 4 + HIDDEN_FILE_ID.length + 2, nameBytes, 0, length);
        return new String(nameBytes);
    }

    public byte[] getContainedBytes(File f, int count) throws IOException, Exception {
        BufferedImage img = ImageIO.read(f);
        byte[] data = new byte[count];
        byte[] prePart = this.assemble(img, ID.length + 4 + HIDDEN_FILE_ID.length + 2);
        short length = HexTool.byteToShortIntLittleEndian(ID.length + 4 + HIDDEN_FILE_ID.length, prePart);
        byte[] beginning = this.assemble(img, ID.length + 4 + HIDDEN_FILE_ID.length + 2 + length + count);
        System.arraycopy(beginning, ID.length + 4 + HIDDEN_FILE_ID.length + 2 + length, data, 0, count);
        return data;
    }
}

