/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

import de.das.encrypter.processors.ProgressListener;
import de.das.encrypter.tools.ByteArrayEncloser;
import de.das.encrypter.tools.HexTool;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class ByteArrayWavEncloser
extends ByteArrayEncloser {
    private final int WAV_FILE_HEADER_LENGTH = 44;
    private final byte[] leftSample = new byte[2];
    private final byte[] rightSample = new byte[2];
    private ProgressListener listener = null;
    private boolean breakIt;

    public ByteArrayWavEncloser() {
        this(null);
    }

    public ByteArrayWavEncloser(ProgressListener pl) {
        this.listener = pl;
    }

    public boolean canHold(int length, File f) {
        return length + 4 + ID.length <= this.getCapacity(f);
    }

    public boolean canHoldFile(File f, File audio) {
        return f.length() + 4L + (long)ID.length + 2L + (long)HIDDEN_FILE_ID.length + (long)f.getName().getBytes().length <= (long)this.getCapacity(audio);
    }

    public int getCapacity(File container) {
        int fileCapacity = (int)(container.length() - 44L) / 2 / 8;
        return fileCapacity;
    }

    public void hideData(byte[] d, File container) throws Exception {
        this.hideData(d, container, true);
    }

    public void hideData(byte[] d, File container, boolean withHeader) throws Exception {
        byte[] data;
        this.breakIt = false;
        if (withHeader) {
            data = new byte[d.length + 4 + ID.length];
            System.arraycopy(d, 0, data, 4 + ID.length, d.length);
            if (!this.canHold(d.length, container)) {
                throw new Exception("WAV file not large enough.");
            }
            System.arraycopy(ID, 0, data, 0, ID.length);
            HexTool.insertIntLittleEndianAt(d.length, ID.length, data);
        } else {
            data = d;
        }
        RandomAccessFile in = new RandomAccessFile(container, "rw");
        int filePointer = 44;
        in.seek(filePointer);
        for (int i = 0; i < data.length && !this.breakIt; ++i) {
            byte b = data[i];
            int mask = 128;
            for (int bitPointer = 0; bitPointer < 4; ++bitPointer) {
                in.read(this.leftSample);
                in.read(this.rightSample);
                this.leftSample[0] = (b & mask) != 0 ? (byte)(this.leftSample[0] | 1) : (byte)(this.leftSample[0] & 0xFE);
                this.rightSample[0] = (b & (mask >>= 1)) != 0 ? (byte)(this.rightSample[0] | 1) : (byte)(this.rightSample[0] & 0xFE);
                mask >>= 1;
                in.seek(filePointer);
                in.write(this.leftSample);
                in.write(this.rightSample);
                filePointer += 4;
            }
            if (this.listener == null || i % 128 != 0) continue;
            this.listener.setCurrentAmount(i);
        }
        if (this.listener != null) {
            this.listener.setCurrentAmount(data.length);
        }
        in.close();
        if (this.breakIt) {
            this.clear(container);
        }
    }

    public boolean containsHiddenFile(File container) throws Exception {
        boolean contains = this.containsHiddenData(container);
        if (contains) {
            try (RandomAccessFile raf = new RandomAccessFile(container, "r");){
                byte[] hfHeader = this.assemble(raf, 44, ID.length + 4 + HIDDEN_FILE_ID.length + 2);
                byte[] hfId = new byte[4];
                System.arraycopy(hfHeader, ID.length + 4, hfId, 0, hfId.length);
                if (!Arrays.equals(hfId, HIDDEN_FILE_ID)) {
                    contains = false;
                }
            }
        }
        return contains;
    }

    public boolean containsHiddenData(File container) throws Exception {
        byte[] header;
        try (RandomAccessFile raf = new RandomAccessFile(container, "r");){
            header = this.assemble(raf, 44, ID.length + 4);
        }
        byte[] id = new byte[ID.length];
        System.arraycopy(header, 0, id, 0, id.length);
        return Arrays.equals(ID, id);
    }

    public byte[] regainData(File container) throws Exception {
        byte[] data = null;
        if (this.containsHiddenData(container)) {
            try (RandomAccessFile raf = new RandomAccessFile(container, "r");){
                byte[] header = this.assemble(raf, 44, ID.length + 4);
                int length = HexTool.byteToIntLittleEndian(ID.length, header);
                data = new byte[length];
                byte[] rafData = this.assemble(raf, 44, length + header.length, true);
                if (rafData != null) {
                    System.arraycopy(rafData, header.length, data, 0, data.length);
                }
            }
        }
        return data;
    }

    public int getHiddenArraySize(File f) throws Exception {
        int length = 0;
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            byte[] header = this.assemble(raf, 44, ID.length + 4);
            length = HexTool.byteToIntLittleEndian(ID.length, header);
        }
        return length;
    }

    public byte[] assemble(File container, int count) throws Exception {
        byte[] data = null;
        try (RandomAccessFile raf = new RandomAccessFile(container, "r");){
            byte[] header = this.assemble(raf, 44, ID.length + 4);
            byte[] rafData = this.assemble(raf, 44, count + header.length);
            if (rafData != null) {
                data = new byte[count];
                System.arraycopy(rafData, header.length, data, 0, data.length);
            }
        }
        return data;
    }

    private byte[] assemble(RandomAccessFile container, int pointer, int count) throws Exception {
        return this.assemble(container, pointer, count, false);
    }

    private byte[] assemble(RandomAccessFile container, int pointer, int count, boolean progress) throws Exception {
        this.breakIt = false;
        byte[] data = new byte[count];
        container.seek(pointer);
        for (int i = 0; i < count && !this.breakIt; ++i) {
            int mask = 128;
            byte b = 0;
            for (int j = 0; j < 4; ++j) {
                container.read(this.leftSample);
                container.read(this.rightSample);
                b = (this.leftSample[0] & 1) != 0 ? (byte)(b | mask) : (byte)(b & ~mask);
                b = (this.rightSample[0] & 1) != 0 ? (byte)(b | mask) : (byte)(b & ~(mask >>= 1));
                mask >>= 1;
            }
            data[i] = b;
            if (this.listener == null || !progress || i % 128 != 0) continue;
            this.listener.setCurrentAmount(i);
        }
        if (this.listener != null && progress) {
            this.listener.setCurrentAmount(count);
        }
        if (this.breakIt) {
            data = null;
        }
        return data;
    }

    public void clear(File container) throws Exception {
        byte[] CLEAR = new byte[]{0, 0, 0, 0};
        this.hideData(CLEAR, container, false);
    }

    public void breakIt() {
        this.breakIt = true;
    }

    public String getHiddenFileName(File container) throws Exception {
        byte[] prePart = this.assemble(container, HIDDEN_FILE_ID.length + 2);
        short length = HexTool.byteToShortIntLittleEndian(HIDDEN_FILE_ID.length, prePart);
        byte[] beginning = this.assemble(container, HIDDEN_FILE_ID.length + 2 + length);
        byte[] nameBytes = new byte[length];
        System.arraycopy(beginning, HIDDEN_FILE_ID.length + 2, nameBytes, 0, length);
        return new String(nameBytes);
    }

    public byte[] getContainedBytes(File container, int count) throws Exception {
        byte[] data = new byte[count];
        byte[] prePart = this.assemble(container, HIDDEN_FILE_ID.length + 2);
        short length = HexTool.byteToShortIntLittleEndian(HIDDEN_FILE_ID.length, prePart);
        byte[] beginning = this.assemble(container, HIDDEN_FILE_ID.length + 2 + length + count);
        System.arraycopy(beginning, HIDDEN_FILE_ID.length + 2 + length, data, 0, count);
        return data;
    }
}

