/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

public class CRC {
    private static final long generator = 79764919L;

    public static int getCRC_16(byte[] data) {
        return CRC.getCRC_16(data, 0);
    }

    public static int getCRC_16(byte[] data, int ignore) {
        int crcValue = 65535;
        for (int i = 0; i < data.length - ignore; ++i) {
            crcValue = CRC.CRC_16_byte(crcValue, data[i]);
        }
        return crcValue & 0xFFFF;
    }

    public static int CRC_16_byte(int prevValue, byte nextByte) {
        int generator16 = 4129;
        int shiftReg = prevValue ^ nextByte << 8;
        for (int i = 0; i < 8; ++i) {
            int leadingBit = shiftReg & 0x8000;
            shiftReg <<= 1;
            if (leadingBit != 32768) continue;
            shiftReg ^= generator16;
        }
        return shiftReg;
    }

    public static long getCRC_32(byte[] data) {
        return CRC.getCRC_32(data, 0);
    }

    public static long getCRC_32(byte[] data, int omit) {
        long crcValue = 0xFFFFFFFFL;
        for (int i = 0; i < data.length - omit; ++i) {
            crcValue = CRC.CRC_32_byte(crcValue, data[i]);
        }
        return (crcValue ^ 0xFFFFFFFFL) & 0xFFFFFFFFL;
    }

    public static long CRC_32_byte(long prevValue, byte nextByte) {
        long shiftReg = prevValue ^ (long)nextByte << 24;
        for (int i = 0; i < 8; ++i) {
            long leadingBit = shiftReg & 0x80000000L;
            shiftReg <<= 1;
            if (leadingBit != 0x80000000L) continue;
            shiftReg ^= 0x4C11DB7L;
        }
        return shiftReg;
    }
}

