/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

import java.io.PrintStream;

public class HexTool {
    public static float[] byteArrayToFloatArray(byte[] byteArray) {
        float[] floatArray = new float[byteArray.length / 4];
        for (int i = 0; i < floatArray.length; ++i) {
            floatArray[i] = HexTool.getFloatAt(i * 4, byteArray);
        }
        return floatArray;
    }

    public static int byteToInt(byte b) {
        return b < 0 ? 256 + b : b;
    }

    public static byte[] floatArrayToByteArray(float[] fArray) {
        byte[] byteArray = new byte[fArray.length * 4];
        for (int i = 0; i < fArray.length; ++i) {
            HexTool.insertFloatAt(i * 4, fArray[i], byteArray);
        }
        return byteArray;
    }

    public static byte[] floatToByteArray(float f) {
        byte[] byteArray = new byte[4];
        HexTool.insertFloatAt(0, f, byteArray);
        return byteArray;
    }

    public static byte[] longToByteArray(long v) {
        byte[] b = new byte[8];
        b[7] = (byte)((v & 0xFF00000000000000L) >> 56);
        b[6] = (byte)((v & 0xFF000000000000L) >> 48);
        b[5] = (byte)((v & 0xFF0000000000L) >> 40);
        b[4] = (byte)((v & 0xFF00000000L) >> 32);
        b[3] = (byte)((v & 0xFF000000L) >> 24);
        b[2] = (byte)((v & 0xFF0000L) >> 16);
        b[1] = (byte)((v & 0xFF00L) >> 8);
        b[0] = (byte)(v & 0xFFL);
        return b;
    }

    public static byte[] longToByteArrayLittleEndian(long v) {
        byte[] b = new byte[8];
        b[7] = (byte)((v & 0xFF00000000000000L) >> 56);
        b[6] = (byte)((v & 0xFF000000000000L) >> 48);
        b[5] = (byte)((v & 0xFF0000000000L) >> 40);
        b[4] = (byte)((v & 0xFF00000000L) >> 32);
        b[3] = (byte)((v & 0xFF000000L) >> 24);
        b[2] = (byte)((v & 0xFF0000L) >> 16);
        b[1] = (byte)((v & 0xFF00L) >> 8);
        b[0] = (byte)(v & 0xFFL);
        return b;
    }

    public static byte[] longToByteArrayBigEndian(long v) {
        byte[] b = new byte[]{(byte)((v & 0xFF00000000000000L) >> 56), (byte)((v & 0xFF000000000000L) >> 48), (byte)((v & 0xFF0000000000L) >> 40), (byte)((v & 0xFF00000000L) >> 32), (byte)((v & 0xFF000000L) >> 24), (byte)((v & 0xFF0000L) >> 16), (byte)((v & 0xFF00L) >> 8), (byte)(v & 0xFFL)};
        return b;
    }

    public static byte[] intToByteArray(int v) {
        byte[] b = new byte[4];
        b[3] = (byte)((v & 0xFF000000) >> 24);
        b[2] = (byte)((v & 0xFF0000) >> 16);
        b[1] = (byte)((v & 0xFF00) >> 8);
        b[0] = (byte)(v & 0xFF);
        return b;
    }

    public static long byteArrayToLong(byte[] b) {
        long v = (long)b[7] << 56 & 0xFF00000000000000L | (long)b[6] << 48 & 0xFF000000000000L | (long)b[5] << 40 & 0xFF0000000000L | (long)b[4] << 32 & 0xFF00000000L | (long)b[3] << 24 & 0xFF000000L | (long)b[2] << 16 & 0xFF0000L | (long)b[1] << 8 & 0xFF00L | (long)b[0] & 0xFFL;
        return v;
    }

    public static String stringFromByteArray(byte[] b) {
        String str = new String(b);
        if (str.contains("\u0000")) {
            str = str.substring(0, str.indexOf("\u0000"));
        }
        return str;
    }

    public static byte[] stringToByteArray(String str) {
        byte[] b = str.getBytes();
        return b;
    }

    public static String toHex(byte b) {
        String s = "";
        int lsb = b & 0xF;
        int msb = (b & 0xF0) >> 4;
        s = s + (msb > 9 ? (char)(msb - 10 + 65) : (char)(msb + 48));
        s = s + (lsb > 9 ? (char)(lsb - 10 + 65) : (char)(lsb + 48));
        return s;
    }

    public static String toTwoHexQuad(int i) {
        String s = HexTool.toHexQuad((short)((i & 0xFFFF0000) >> 16)) + HexTool.toHexQuad((short)(i & 0xFFFF));
        return s;
    }

    public static String toHexQuad(short sh) {
        String s = "";
        int[] b = new int[]{sh & 0xF, (sh & 0xF0) >> 4, (sh & 0xF00) >> 8, (sh & 0xF000) >> 12};
        for (int i = 3; i >= 0; --i) {
            s = s + (b[i] > 9 ? (char)(b[i] - 10 + 65) : (char)(b[i] + 48));
        }
        return s;
    }

    public static byte parseHex(String str) throws NumberFormatException {
        if (str.length() != 2) {
            throw new NumberFormatException();
        }
        str = str.toUpperCase();
        byte b = 0;
        char c = str.charAt(0);
        if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
            throw new NumberFormatException();
        }
        byte msb = c > '9' ? (byte)((byte)c - 65 + 10) : (byte)((byte)c - 48);
        c = str.charAt(1);
        if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
            throw new NumberFormatException();
        }
        byte lsb = c > '9' ? (byte)((byte)c - 65 + 10) : (byte)((byte)c - 48);
        b = (byte)(msb * 16 + lsb);
        return b;
    }

    public static String fillLeadingPositions(String s, int n, char c) {
        while (s.length() < n) {
            s = c + s;
        }
        return s;
    }

    public static short parseQuadHex(String str) throws NumberFormatException {
        if (str.length() > 4) {
            throw new NumberFormatException();
        }
        while (str.length() < 4) {
            str = "0" + str;
        }
        byte msb = HexTool.parseHex(str.substring(0, 2));
        byte lsb = HexTool.parseHex(str.substring(2, 4));
        return HexTool.byteToWord(msb, lsb);
    }

    public static short byteToWord(int msb, int lsb) {
        int result = 0;
        lsb = lsb < 0 ? 256 + lsb : lsb;
        msb = msb < 0 ? 256 + msb : msb;
        return (short)((result | msb) << 8 | lsb);
    }

    public static int byteToInt(int msb, int lsb) {
        lsb = lsb < 0 ? 256 + lsb : lsb;
        msb = msb < 0 ? 256 + msb : msb;
        return msb << 8 | lsb;
    }

    public static int byteToInt(int msb, int csb, int lsb) {
        lsb = lsb < 0 ? 256 + lsb : lsb;
        csb = csb < 0 ? 256 + csb : csb;
        msb = msb < 0 ? 256 + msb : msb;
        return msb << 16 | csb << 8 | lsb;
    }

    public static int byteToInt(byte[] bytes) {
        int[] b = new int[4];
        b[3] = bytes[3];
        b[2] = bytes[2];
        b[1] = bytes[1];
        b[0] = bytes[0];
        b[3] = b[3] << 24 & 0xFF000000;
        b[2] = b[2] << 16 & 0xFF0000;
        b[1] = b[1] << 8 & 0xFF00;
        b[0] = b[0] & 0xFF;
        return b[3] | b[2] | b[1] | b[0];
    }

    public static long byteToLongLittleEndian(byte[] bytes) {
        long[] b = new long[8];
        b[7] = bytes[7];
        b[6] = bytes[6];
        b[5] = bytes[5];
        b[4] = bytes[4];
        b[3] = bytes[3];
        b[2] = bytes[2];
        b[1] = bytes[1];
        b[0] = bytes[0];
        b[7] = b[7] << 56 & 0xFF00000000000000L;
        b[6] = b[6] << 48 & 0xFF000000000000L;
        b[5] = b[5] << 40 & 0xFF0000000000L;
        b[4] = b[4] << 32 & 0xFF00000000L;
        b[3] = b[3] << 24 & 0xFF000000L;
        b[2] = b[2] << 16 & 0xFF0000L;
        b[1] = b[1] << 8 & 0xFF00L;
        b[0] = b[0] & 0xFFL;
        return b[7] | b[6] | b[5] | b[4] | b[3] | b[2] | b[1] | b[0];
    }

    public static long byteToLongLittleEndian(byte[] bytes, int pos) {
        long[] b = new long[8];
        b[7] = bytes[7 + pos];
        b[6] = bytes[6 + pos];
        b[5] = bytes[5 + pos];
        b[4] = bytes[4 + pos];
        b[3] = bytes[3 + pos];
        b[2] = bytes[2 + pos];
        b[1] = bytes[1 + pos];
        b[0] = bytes[0 + pos];
        b[7] = b[7] << 56 & 0xFF00000000000000L;
        b[6] = b[6] << 48 & 0xFF000000000000L;
        b[5] = b[5] << 40 & 0xFF0000000000L;
        b[4] = b[4] << 32 & 0xFF00000000L;
        b[3] = b[3] << 24 & 0xFF000000L;
        b[2] = b[2] << 16 & 0xFF0000L;
        b[1] = b[1] << 8 & 0xFF00L;
        b[0] = b[0] & 0xFFL;
        return b[7] | b[6] | b[5] | b[4] | b[3] | b[2] | b[1] | b[0];
    }

    public static int byteToIntLittleEndian(int pos, byte[] bytes) {
        int[] b = new int[]{bytes[0 + pos], bytes[1 + pos], bytes[2 + pos], bytes[3 + pos]};
        b[3] = b[3] << 24 & 0xFF000000;
        b[2] = b[2] << 16 & 0xFF0000;
        b[1] = b[1] << 8 & 0xFF00;
        b[0] = b[0] & 0xFF;
        return b[3] | b[2] | b[1] | b[0];
    }

    public static long byteToLongBigEndian(byte[] bytes, int pos) {
        long[] b = new long[8];
        b[7] = bytes[0 + pos];
        b[6] = bytes[1 + pos];
        b[5] = bytes[2 + pos];
        b[4] = bytes[3 + pos];
        b[3] = bytes[4 + pos];
        b[2] = bytes[5 + pos];
        b[1] = bytes[6 + pos];
        b[0] = bytes[7 + pos];
        b[7] = b[7] << 56 & 0xFF00000000000000L;
        b[6] = b[6] << 48 & 0xFF000000000000L;
        b[5] = b[5] << 40 & 0xFF0000000000L;
        b[4] = b[4] << 32 & 0xFF00000000L;
        b[3] = b[3] << 24 & 0xFF000000L;
        b[2] = b[2] << 16 & 0xFF0000L;
        b[1] = b[1] << 8 & 0xFF00L;
        b[0] = b[0] & 0xFFL;
        return b[7] | b[6] | b[5] | b[4] | b[3] | b[2] | b[1] | b[0];
    }

    public static long byteToUintLittleEndian(int pos, byte[] bytes) {
        long[] b = new long[]{bytes[0 + pos], bytes[1 + pos], bytes[2 + pos], bytes[3 + pos]};
        b[0] = b[0] < 0L ? 256L + b[0] : b[0];
        b[1] = b[1] < 0L ? 256L + b[1] : b[1];
        b[2] = b[2] < 0L ? 256L + b[2] : b[2];
        b[3] = b[3] < 0L ? 256L + b[3] : b[3];
        b[3] = b[3] << 24 & 0xFFFFFFFFFF000000L;
        b[2] = b[2] << 16 & 0xFF0000L;
        b[1] = b[1] << 8 & 0xFF00L;
        b[0] = b[0] & 0xFFL;
        return b[3] | b[2] | b[1] | b[0];
    }

    public static int byteToIntBigEndian(int pos, byte[] bytes) {
        int[] b = new int[4];
        b[3] = bytes[0 + pos];
        b[2] = bytes[1 + pos];
        b[1] = bytes[2 + pos];
        b[0] = bytes[3 + pos];
        b[3] = b[3] << 24 & 0xFF000000;
        b[2] = b[2] << 16 & 0xFF0000;
        b[1] = b[1] << 8 & 0xFF00;
        b[0] = b[0] & 0xFF;
        return b[3] | b[2] | b[1] | b[0];
    }

    public static long byteToUintBigEndian(int pos, byte[] bytes) {
        long[] b = new long[4];
        b[3] = bytes[0 + pos];
        b[2] = bytes[1 + pos];
        b[1] = bytes[2 + pos];
        b[0] = bytes[3 + pos];
        b[0] = b[0] < 0L ? 256L + b[0] : b[0];
        b[1] = b[1] < 0L ? 256L + b[1] : b[1];
        b[2] = b[2] < 0L ? 256L + b[2] : b[2];
        b[3] = b[3] < 0L ? 256L + b[3] : b[3];
        b[3] = b[3] << 24 & 0xFFFFFFFFFF000000L;
        b[2] = b[2] << 16 & 0xFF0000L;
        b[1] = b[1] << 8 & 0xFF00L;
        b[0] = b[0] & 0xFFL;
        return b[3] | b[2] | b[1] | b[0];
    }

    public static int byteToWordLittleEndian(int pos, byte[] bytes) {
        int[] b = new int[]{bytes[0 + pos], bytes[1 + pos]};
        b[1] = b[1] << 8 & 0xFF00;
        b[0] = b[0] & 0xFF;
        return b[1] | b[0];
    }

    public static int byteToWordBigEndian(int pos, byte[] bytes) {
        int[] b = new int[2];
        b[1] = bytes[0 + pos];
        b[0] = bytes[1 + pos];
        b[1] = b[1] << 8 & 0xFF00;
        b[0] = b[0] & 0xFF;
        return b[1] | b[0];
    }

    public static short byteToShortIntBigEndian(int pos, byte[] bytes) {
        int[] b = new int[2];
        b[1] = bytes[0 + pos];
        b[0] = bytes[1 + pos];
        b[1] = b[1] << 8 & 0xFF00;
        b[0] = b[0] & 0xFF;
        return (short)(b[1] | b[0]);
    }

    public static short byteToShortIntLittleEndian(int pos, byte[] bytes) {
        int[] b = new int[2];
        b[1] = bytes[1 + pos];
        b[0] = bytes[0 + pos];
        b[1] = b[1] << 8 & 0xFF00;
        b[0] = b[0] & 0xFF;
        return (short)(b[1] | b[0]);
    }

    public static String byteToString(byte[] data, int start, int length) {
        String result = "";
        for (int i = start; i < start + length; ++i) {
            result = result + (char)data[i];
        }
        return result;
    }

    public static String byteArrayToString(byte[] data) {
        return HexTool.byteArrayToString(data, 0);
    }

    public static String byteArrayToString(byte[] data, int blockSize) {
        String str = "";
        int count = 0;
        for (byte b : data) {
            str = str + HexTool.toHex(b) + " ";
            if (blockSize > 0 && count % blockSize == blockSize - 1) {
                str = str + "- ";
            }
            ++count;
        }
        return str;
    }

    public static void insertIntAt(int v, int pos, byte[] data) {
        data[pos + 3] = (byte)(v & 0xFF);
        data[pos + 2] = (byte)((v & 0xFF00) >> 8);
        data[pos + 1] = (byte)((v & 0xFF0000) >> 16);
        data[pos + 0] = (byte)((v & 0xFF000000) >> 24);
    }

    public static void insertIntAt(long v, int pos, byte[] data) {
        data[pos + 3] = (byte)(v & 0xFFL);
        data[pos + 2] = (byte)((v & 0xFF00L) >> 8);
        data[pos + 1] = (byte)((v & 0xFF0000L) >> 16);
        data[pos + 0] = (byte)((v & 0xFFFFFFFFFF000000L) >> 24);
    }

    public static void insertIntBigEndianAt(long v, int pos, byte[] data) {
        data[pos + 3] = (byte)(v & 0xFFL);
        data[pos + 2] = (byte)((v & 0xFF00L) >> 8);
        data[pos + 1] = (byte)((v & 0xFF0000L) >> 16);
        data[pos + 0] = (byte)((v & 0xFFFFFFFFFF000000L) >> 24);
    }

    public static void insertIntLittleEndianAt(long v, int pos, byte[] data) {
        data[pos + 0] = (byte)(v & 0xFFL);
        data[pos + 1] = (byte)((v & 0xFF00L) >> 8);
        data[pos + 2] = (byte)((v & 0xFF0000L) >> 16);
        data[pos + 3] = (byte)((v & 0xFFFFFFFFFF000000L) >> 24);
    }

    public static void insertLongLittleEndianAt(long v, int pos, byte[] data) {
        data[pos + 0] = (byte)(v & 0xFFL);
        data[pos + 1] = (byte)((v & 0xFF00L) >> 8);
        data[pos + 2] = (byte)((v & 0xFF0000L) >> 16);
        data[pos + 3] = (byte)((v & 0xFF000000L) >> 24);
        data[pos + 4] = (byte)((v & 0xFF00000000L) >> 32);
        data[pos + 5] = (byte)((v & 0xFF0000000000L) >> 40);
        data[pos + 6] = (byte)((v & 0xFF000000000000L) >> 48);
        data[pos + 7] = (byte)((v & 0xFF00000000000000L) >> 56);
    }

    public static void insertShortIntAt(int v, int pos, byte[] data) {
        data[pos + 1] = (byte)(v & 0xFF);
        data[pos + 0] = (byte)((v & 0xFF00) >> 8);
    }

    public static void insertShortIntBigEndianAt(int v, int pos, byte[] data) {
        data[pos + 1] = (byte)(v & 0xFF);
        data[pos + 0] = (byte)((v & 0xFF00) >> 8);
    }

    public static void insertShortIntLittleEndianAt(int v, int pos, byte[] data) {
        data[pos + 0] = (byte)(v & 0xFF);
        data[pos + 1] = (byte)((v & 0xFF00) >> 8);
    }

    public static void insertFloatAt(int pos, float fValue, byte[] data) {
        int value = Float.floatToIntBits(fValue);
        data[pos + 3] = (byte)(value & 0xFF);
        data[pos + 2] = (byte)((value & 0xFF00) >> 8);
        data[pos + 1] = (byte)((value & 0xFF0000) >> 16);
        data[pos + 0] = (byte)((value & 0xFF000000) >> 24);
    }

    public static float getFloatAt(int pos, byte[] data) {
        return Float.intBitsToFloat(HexTool.getIntAt(pos, data));
    }

    public static int getIntAt(int pos, byte[] data) {
        int[] b = new int[4];
        b[3] = data[pos + 0];
        b[2] = data[pos + 1];
        b[1] = data[pos + 2];
        b[0] = data[pos + 3];
        b[3] = b[3] << 24 & 0xFF000000;
        b[2] = b[2] << 16 & 0xFF0000;
        b[1] = b[1] << 8 & 0xFF00;
        b[0] = b[0] & 0xFF;
        int value = b[3] | b[2] | b[1] | b[0];
        return value;
    }

    public static long getLongAt(int pos, byte[] data) {
        long[] b = new long[8];
        b[7] = data[pos + 0];
        b[6] = data[pos + 1];
        b[5] = data[pos + 2];
        b[4] = data[pos + 3];
        b[3] = data[pos + 4];
        b[2] = data[pos + 5];
        b[1] = data[pos + 6];
        b[0] = data[pos + 7];
        b[7] = b[7] << 56 & 0xFF00000000000000L;
        b[6] = b[6] << 48 & 0xFF000000000000L;
        b[5] = b[5] << 40 & 0xFF0000000000L;
        b[4] = b[4] << 32 & 0xFF00000000L;
        b[3] = b[3] << 24 & 0xFF000000L;
        b[2] = b[2] << 16 & 0xFF0000L;
        b[1] = b[1] << 8 & 0xFF00L;
        b[0] = b[0] & 0xFFL;
        long value = b[7] | b[6] | b[5] | b[4] | b[3] | b[2] | b[1] | b[0];
        return value;
    }

    public static String getHexString(byte[] data) {
        String s = "";
        for (byte b : data) {
            s = s + HexTool.toHex(b) + " ";
        }
        return s;
    }

    public static void printBuffer(PrintStream out, byte[] data) {
        out.print(HexTool.getHexString(data));
    }

    public static void printBuffer(byte[] data) {
        HexTool.printBuffer(System.out, data);
    }

    public static void printlnBuffer(byte[] data) {
        HexTool.printBuffer(data);
        System.out.println();
    }

    public static String createFormattedHexList(byte[] data) {
        return HexTool.createFormattedHexList(0, data, "  ");
    }

    public static String createFormattedHexList(byte[] data, String centerDiv) {
        return HexTool.createFormattedHexList(0, data, centerDiv);
    }

    public static String createFormattedHexList(int adr, byte[] data, String centerDiv) {
        byte[] page = new byte[128];
        int pages = data.length / 128;
        if (pages * 128 < data.length) {
            ++pages;
        }
        byte[] byteOctalPackage = new byte[8];
        short adrLow = (short)(adr & 0xFFFF);
        short adrHigh = (short)((adr & 0xFFFF0000) >> 16);
        String line = "";
        boolean breakNow = false;
        block0: for (int j = 0; j < pages; ++j) {
            line = line + "\n";
            int byteCount = 128;
            if (data.length - j * 128 < 128) {
                byteCount = data.length - j * 128;
            }
            System.arraycopy(data, j * 128, page, 0, byteCount);
            for (int octalCounter = 0; octalCounter < 16; ++octalCounter) {
                int n = j * 128 + (octalCounter + 1) * 8;
                if (n > data.length) {
                    byteOctalPackage = new byte[8 - (n - data.length)];
                    System.arraycopy(page, octalCounter * 8, byteOctalPackage, 0, byteOctalPackage.length);
                    breakNow = true;
                } else {
                    System.arraycopy(page, octalCounter * 8, byteOctalPackage, 0, 8);
                }
                if (octalCounter - octalCounter / 2 * 2 == 0) {
                    line = line + "\n" + HexTool.toHexQuad(adrHigh) + HexTool.toHexQuad(adrLow) + ": ";
                    adrHigh = adrLow + 16 > 65535 ? (short)(adrHigh + 1) : adrHigh;
                    adrLow = (short)(adrLow + 16);
                } else {
                    line = line + centerDiv;
                }
                line = line + HexTool.byteArrayToString(byteOctalPackage);
                if (breakNow) break block0;
            }
        }
        return line;
    }

    public static byte[] swapBytes(byte[] data) {
        for (int i = 0; i < data.length / 2; ++i) {
            byte tmp = data[i];
            data[i] = data[data.length - i - 1];
            data[data.length - i - 1] = tmp;
        }
        return data;
    }
}

