/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import de.das.encrypter.model.KeyFile;
import de.das.encrypter.tools.ByteArrayConverter;
import de.das.encrypter.tools.ByteArrayImgEncloser;
import de.das.encrypter.tools.ByteArrayWavEncloser;
import de.das.encrypter.tools.HexTool;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class HiddenDataTool {
    private final ByteArrayWavEncloser bawe = new ByteArrayWavEncloser();
    private final ByteArrayImgEncloser baie = new ByteArrayImgEncloser();

    public byte[] keyFromQr(File f) {
        byte[] data = this.byteArrayFromQr(f);
        if (data != null && !KeyFile.isValidKey(data)) {
            data = null;
        }
        return data;
    }

    public boolean keyInQr(File f) throws Exception {
        boolean contains = false;
        byte[] data = this.byteArrayFromQr(f);
        if (data != null) {
            byte[] keyfileId = new byte[8];
            System.arraycopy(data, 0, keyfileId, 0, keyfileId.length);
            contains = Arrays.equals(keyfileId, "KEYFILE_".getBytes());
        }
        return contains;
    }

    public boolean keyInWav(File f) throws Exception {
        boolean contains = false;
        if (this.bawe.containsHiddenData(f)) {
            byte[] keyfileId = this.bawe.assemble(f, 8);
            contains = Arrays.equals(keyfileId, "KEYFILE_".getBytes());
        }
        return contains;
    }

    public boolean keyInPng(File f) throws Exception {
        boolean contains = false;
        if (this.baie.containsHiddenData(f)) {
            BufferedImage img = ImageIO.read(f);
            byte[] data = this.baie.assemble(img, 32);
            byte[] keyfileId = new byte[8];
            System.arraycopy(data, 4 + ByteArrayImgEncloser.ID.length, keyfileId, 0, keyfileId.length);
            contains = Arrays.equals(keyfileId, "KEYFILE_".getBytes());
        }
        return contains;
    }

    public byte[] byteArrayFromImg(File f) {
        byte[] data = null;
        try {
            BufferedImage img = ImageIO.read(f);
            if (img != null && this.baie.containsHiddenData(img)) {
                data = this.baie.regainData(img);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public byte[] byteArrayFromWav(File f) {
        byte[] data = null;
        try {
            if (this.bawe.containsHiddenData(f)) {
                data = this.bawe.regainData(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public byte[] byteArrayFromQr(File f) {
        byte[] data = null;
        try {
            String content;
            BufferedImage img = ImageIO.read(f);
            if (img != null && (content = this.readQRCode(img)) != null) {
                ByteArrayConverter bac = new ByteArrayConverter();
                data = bac.stringToByteArray(content);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    private String readQRCode(BufferedImage image) throws Exception {
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        RGBLuminanceSource source = new RGBLuminanceSource(image.getWidth(), image.getHeight(), pixels);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        QRCodeReader reader = new QRCodeReader();
        try {
            Result result = reader.decode(bitmap);
            return result.getText();
        }
        catch (NotFoundException notFoundException) {
        }
        catch (ChecksumException checksumException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return null;
    }

    public String getKeyNameFromWav(File f) {
        String name = "";
        try {
            if (this.bawe.containsHiddenData(f)) {
                byte[] keyfileId = this.bawe.assemble(f, 26);
                byte[] amountBytes = new byte[2];
                System.arraycopy(keyfileId, 24, amountBytes, 0, amountBytes.length);
                byte nameLength = HexTool.parseHex(new String(amountBytes));
                keyfileId = this.bawe.assemble(f, 26 + nameLength);
                name = KeyFile.getKeyName(keyfileId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public String getKeyNameFromImg(File f) {
        String name = "";
        try {
            BufferedImage img = ImageIO.read(f);
            if (this.baie.containsHiddenData(f)) {
                byte[] data = this.baie.assemble(img, 30 + ByteArrayImgEncloser.ID.length);
                byte[] keyfileId = new byte[26];
                System.arraycopy(data, 4 + ByteArrayImgEncloser.ID.length, keyfileId, 0, keyfileId.length);
                byte[] amountBytes = new byte[2];
                System.arraycopy(keyfileId, 24, amountBytes, 0, amountBytes.length);
                byte nameLength = HexTool.parseHex(new String(amountBytes));
                data = this.baie.assemble(img, 26 + nameLength + 4 + ByteArrayImgEncloser.ID.length);
                keyfileId = new byte[26 + nameLength];
                System.arraycopy(data, 4 + ByteArrayImgEncloser.ID.length, keyfileId, 0, keyfileId.length);
                name = KeyFile.getKeyName(keyfileId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }
}

