/*
 * Decompiled with CFR 0.152.
 */
package de.das.encrypter.tools;

import de.das.encrypter.tools.HexTool;

public class KeyQualityAssessor {
    public static final int QUALITY = 0;
    public static final int SCATTERING = 1;

    public Double[] determineQuality(byte[] key) {
        double[] norm = new double[256];
        int[] counts = new int[256];
        int[] difCounts = new int[256];
        double minNorm = Double.MAX_VALUE;
        double maxNorm = Double.MIN_VALUE;
        byte[] amountBytes = new byte[2];
        System.arraycopy(key, 24, amountBytes, 0, amountBytes.length);
        byte nn = HexTool.parseHex(new String(amountBytes));
        int startPoint = 26 + nn;
        byte[] pureKey = new byte[key.length - (26 + nn + 4)];
        System.arraycopy(key, startPoint, pureKey, 0, pureKey.length);
        double q = 0.0;
        int prevByte = -1;
        for (byte b : pureKey) {
            int byteValue;
            int n = byteValue = HexTool.byteToInt(b);
            counts[n] = counts[n] + 1;
            if (prevByte >= 0) {
                int n2 = Math.abs(prevByte - byteValue);
                difCounts[n2] = difCounts[n2] + 1;
            }
            prevByte = byteValue;
        }
        double quality = 0.0;
        double max = 0.0;
        for (int v : counts) {
            if (!((double)v > max)) continue;
            max = v;
        }
        for (int i = 1; i < norm.length; ++i) {
            norm[i] = (double)counts[i] / max;
            if (norm[i] > maxNorm) {
                maxNorm = norm[i];
            }
            if (norm[i] < minNorm) {
                minNorm = norm[i];
            }
            quality += norm[i];
        }
        Double[] res = new Double[]{quality / 255.0, 1.0 - (maxNorm - minNorm)};
        return res;
    }
}

