package de.das.encrypter.comm;

/**
 * Interface for classes which want get byte arrays from a UDP receiver.
 * 
 * @author Dipl. Phys.-Ing. Frank Keldenich
 */
public interface DataReceiver
{
  /**
   * Passes the received data to the instance of the class that implements the 
   * DataReceiver interface and has registered with the UDP receiver.
   * 
   * @param data the byte array received by a UDP receiver.
   */
  public void setData (byte [] data);
  
  /**
   * Passes the received data and the IP-address of the sender to the instance 
   * of the class that implements the DataReceiver interface and has registered 
   * with the UDP receiver.
   * 
   * @param host the IP address of the sender.
   * @param data the byte array received by a UDP receiver.
   */
  public void setData (String host, byte [] data);
}
