package de.das.encrypter.examples;

import de.das.encrypter.model.KeyFile;

import java.io.File;

/**
 * This example demonstrates how EncryptionFactory will be used for the creation 
 * of keys. The parameters to be specified are the length of the keys, the length 
 * of their names (which is formed here from random characters but can be any file 
 * name), the number of keys (means the size of the key bundle) and the 
 * destination (preferably the "Bundle" folder in the root directory of a 
 * drive).
 * 
 * The generated keys then have a unique ID and the header by which the 
 * EncryptionFactory can identify the key bundles. The automatic key bundle 
 * searcher will find them later.
 * 
 * @author Dipl.-Phys. Ing. Frank Keldenich
 */
public class KeyCreationExample 
{
  // The target folder where the key bundle shall be written to.
  private final String TARGET_FOLDER = "E:\\Bundle";
  
  // The number of key bundles that shall be created.
  private final int NUMBER_OF_KEY_BUNDLES = 32;
  
  // The length of the random names.
  private final int NAME_LENGTH = 30;
  
  // The length of the key bundles (which is also the number of different keys).
  private final int KEY_LENGTH = 1024;
  
  public static void main (String [] args)
  {
    try
    {
      new KeyCreationExample().execute();
    } 
    catch (Exception e)
    {
      e.printStackTrace();
    }
    System.exit(0);
  }

  private void execute() throws Exception
  {
    // Create the target folder if it does not exist yet.
    File dir = new File (TARGET_FOLDER);
    if (!dir.exists())
    {
      dir.mkdirs();
    }
    
    String keyBundleName;
    // Create one key bundle after the other.
    for (int i = 0; i < NUMBER_OF_KEY_BUNDLES; i++)
    {
      // Get a random name for the next key bundle.
      keyBundleName = KeyFile.randomFileName(NAME_LENGTH);
      // Create the key bundle which will be written to the specified target.
      KeyFile.create(new File (TARGET_FOLDER + File.separator + keyBundleName), KEY_LENGTH);
    }
  }
}
