package de.das.encrypter.fourier;

/**
 * Class to represent complex numbers.
 * 
 * @author Frank Keldenich
 */
public class Complex 
{
  public double re = 0;
  
  public double im = 0;

  /**
   * Creates an instance of a complex number.
   * 
   * @param re the real part of the complex number.
   * @param im the imaginary part of the complex number.
   */
  public Complex(double re, double im) 
  {
    this.re = re;
    this.im = im;
  }
  
  /**
   * Adds two given complex numbers.
   * 
   * @param z1 the complex number one.
   * @param z2 the complex number two.
   * @return the sum of the given complex numbers.
   */
  public static Complex add(Complex z1, Complex z2) 
  {
    return new Complex(z1.re + z2.re, z1.im + z2.im);
  }

  /**
   * Subtracts a given complex numbers from anther given complex number.
   * 
   * @param z1 the complex number one.
   * @param z2 the complex number two.
   * @return the difference of z2 subtracted from z1.
   */
  public static Complex subtract(Complex z1, Complex z2) 
  {
    return new Complex(z1.re - z2.re, z1.im - z2.im);
  }
  
  /**
   * Multiplies two given complex numbers.
   * 
   * @param z1 the complex number one.
   * @param z2 the complex number two.
   * @return the product of the given complex numbers.
   */
  public static Complex multiply(Complex z1, Complex z2) 
  {		
    return new Complex(z1.re * z2.re - z1.im * z2.im, z1.re * z2.im + z1.im * z2.re);

  }

  /**
   * Divides a given complex number by a real value.
   * 
   * @param z a complex number.
   * @param r a real value.
   * @return the quotient of z1 divided by z2.
   */
  public static Complex divideR(Complex z, double r) 
  {
    return new Complex(z.re / r, z.im / r);
  }

  /**
   * Calculates and returns the absolute value of a given complex number.
   * 
   * @param z a given complex number.
   * 
   * @return the magnitude of a given complex number.
   */
  public static double magnitude(Complex z) 
  {
    return Math.sqrt(z.re * z.re + z.im * z.im);
  }
}