package de.das.encrypter.model;

/**
 * An entry point supplier delivers an entry point into the pure key bundle 
 * and monitors the entry points used until now via the given key bundle ID.
 * 
 * @author Frank Keldenich
 */
public interface EntryPointSupplier 
{
  /**
   * Provides an until unused entry point into the given pure data of a key 
   * bundle.
   * 
   * @param id the id of the key bundle used to supervize the usage of still 
   * used entry points.
   * @param key the pure key data.
   * @return an until now unused entry point.
   * 
   * @throws Exception in case of any error.
   */
  public Integer getEntryPoint(long id, byte [] key) throws Exception;
}
