package de.das.encrypter.model;

/**
 * Interface for specifying required constants and positions of values in the 
 * key and encryption headers.
 * 
 * @author Dipl. Phys.-Ing. Frank Keldenich
 */
public interface Key
{
  /**
   * The value of one mega byte.
   */
  public static final int MB = 1024 * 1024;
  
  /**
   * The value of one kilo byte.
   */
  public static final int KB = 1024;
  
  /**
   * Starting of an enryption key.
   */
  public static final String KEY_SIGNATURE_PREFIX = "KEYFILE_";
  
  /**
   * Number of bytes representing the key ID which is a hex string.
   */
  public static final int KEY_ID_LENGHT = 16;
  
  /**
   * Signature for encrypted data.
   */
  public static final String ENCRYPTION_ID = "@@&&$$";
  
  /**
   * Length of the signature for encrypted data.
   */
  public static final int ENCRYPTION_ID_LENGTH = ENCRYPTION_ID.length();
  
  /**
   * Length of the key header.
   */
  public static final int KEY_HEADER_LENGTH = 24;
  
  /**
   * Position of the key name.
   */
  public static final int KEY_NAME_POSITION = 24;
  
  /**
   * Total length of the encryption prefix which consists of encryption ID 
   * (= 6 Byte String) + "key ID" (= 16 Byte hex string) + "key entry point" 
   * (= 2 x 8 Byte hex string) + CRC16 of the header (= 2 Byte hex, 
   * little endian).
   */
  public static final int ENCRYPTION_PREFIX_LENGHT = 40;
  
  /**
   * Position of the ID in encrypted data.
   */
  public static final int ENCRYPTION_PREFIX_ID_POSITION = 0;
  
  /**
   * Position of the ID of the key used.
   */
  public static final int ENCRYPTION_PREFIX_KEY_ID_POSITION = 6;
  
  /**
   * Position of the MSB part of the key entry point.
   */
  public static final int ENCRYPTION_PREFIX_ENTRY_POINT_MSB_POSITION = 22;
  
  /**
   * Position of the LSB part of the key entry point.
   */
  public static final int ENCRYPTION_PREFIX_ENTRY_POINT_LSB_POSITION = 30;
  
  /**
   * Position of the 16 Bit CRC of the encryption prefix (header).
   */
  public static final int ENCRYPTION_PREFIX_CRC_16_POSITION = 38;
  
  /**
   * Position of the length of the following file name.
   */
  public static final int ENCRYPTION_PREFIX_NAME_LENGTH_POSITION = 40;
  
  /**
   * Position of the file name of the original unencrypted data file.
   */
  public static final int ENCRYPTION_PREFIX_FILE_NAME_POSITION = 42;
  
  /**
   * Number of characters for the random file names of encrytped files.
   */
  public static final int RANDOM_FILE_NAME_LENGTH = 30;
  
  /**
   * Content of the file that identifies external media as a key carrier.
   */
  public static final String KEY_DRIVE_MARK = "($%%$)31#909#";
  
  /**
   * Name of the file that identifies external media as a key carrier.
   */
  public static final String KEY_DRIVE_MARK_FILE_NAME = "a45f210b4cd22af";
  
  /**
   * Prefix of the name of a file containing the encrypted name of the folder 
   * in which it is located.
   */
  public static final String RANDOM_FOLDER_PREFIX = "abd4fccg32";
  
  /**
   * Index into result array of diversity calculation to value of count of equal
   * bytes at same position.
   */
  public static final int DIVERSITY_EQUAL_COUNTS = 0;
  
  /**
   * Index into result array of diversity calculation to value of realtive 
   * occurances of equal bytes at same position.
   */
  public static final int DIVERSITY_RELATIVE_EQUALS = 1;
  
  /**
   * Index into result array of diversity calculation to value of average 
   * distances of bytes at same position.
   */
  public static final int DIVERSITY_AVE_DISTANCES = 2;
}
