package de.das.encrypter.model;

/**
 * Class to provide information of a key and its location not the key itself.
 * 
 * @author Frank Keldenich
 */
public class KeyFileLocation 
{
  private final String keyName;
  
  private final long keyId;
  
  private final String keyLocation;

  /**
   * Creates a new instance of KeyFileLocation.
   * 
   * @param keyName the name of the key.
   * @param keyId the ID of the key.
   * @param keyLocation the location of the key.
   */
  public KeyFileLocation(String keyName, long keyId, String keyLocation)
  {
    this.keyName = keyName;
    this.keyId = keyId;
    this.keyLocation = keyLocation;
  }

  /**
   * Returns the key ID.
   * @return the key ID.
   */
  public long getKeyId()
  {
    return keyId;
  }

  /**
   * Returns the key location.
   * @return  the key location.
   */
  public String getKeyLocation()
  {
    return keyLocation;
  }

  /**
   * Returns the name of the key.
   * @return  the name of the key.
   */
  public String getKeyName()
  {
    return keyName;
  }
  
}
