package de.das.encrypter.model;

import java.io.File;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * A hash map with the key file objects of all detected keys.
 * 
 * @author Frank Keldenich
 */
public class KeyFiles extends HashMap < Long, KeyFile >
{
  /**
   * The name of the folder located in the root of drives that can contain keys.
   */
  public static String FOLDER_NAME = "Bundle";


  /**
   * Scans all drives form "C" to "Z".
   * 
   * @return a list with all root folders of all available drives.
   */
  public static ArrayList < File >  searchForDrives()
  {
    ArrayList < File > foundFiles = new ArrayList <> ();
    File f;
    String rootStr;
    char [] root = {'C'};
    
    while (root[0] <= 'Z')
    {
      rootStr = new String (root) + ":\\";
      f = new File (rootStr);
      if (f.exists())
      {
        foundFiles.add(f);
      }
      root[0] = (char)((int)root[0] + 1);
    }
    return foundFiles;
  }
  
  public Long getKeyIdByKeyName(String name) throws Exception
  {
    Long id = null;
    for (KeyFile kf: values())
    {
      if (KeyFile.getKeyName(kf.getKey()).equals(name))
      {
        id = kf.getId();
        break;
      }
    }
    return id;
  }
}
