package de.das.encrypter.processors;

/**
 * This interface defines parameters and positions for blockwise UDP data 
 * transfer.
 * 
 * @author Dipl. Phys.-Ing. Frank Keldenich
 */
public interface KeyTransfer
{
  /**
   * Information for the data receiver that all data has been transferred.
   */
  public static final byte [] EOT = "EOT".getBytes();
  
  /**
   * Feedback from the data receiver that the transmission was successful.
   */
  public static final byte [] VALID = "VALID".getBytes();
  
  /**
   * Feedback from the data receiver that the transmission was faulty.
   */
  public static final byte [] FAIL = "FAIL".getBytes();
  
  /**
   * The size of each block used by the Splitter.
   */
  public static final int BUFFER_SIZE = 16384;
  
  /**
   * The position of the block count information in the header.
   */
  public static final int POS_BLOCK_COUNT = 0;
  
  /**
   * The position of the data length information in the header.
   */
  public static final int POS_KEY_LENGTH = 4;
  
  /**
   * The position of the information in the header where the data block starts.
   */
  public static final int POS_BLOCK_START = 12;
    
  /**
   * The position of the information in the header which size the data block has.
   */
  public static final int POS_DATA_SIZE = 8;
    
  /**
   * 12 byte for the header parameter and 4 byte for the CRC-32 at the end of 
   * each block.
   */
  public static final int ADD_DATA_SIZE = 16;
    
}
