package de.das.encrypter.processors;

/**
 * Interface for classes which want to get information about a current progress.
 * Such classes should know the maximum value if they want to work with 
 * percentages, because the current amounts are assumed to be absolute values.
 * 
 * @author Dipl. Phys.-Ing. Frank Keldenich
 */
public interface ProgressListener
{
  /**
   * Sets the actual value of the progress.
   * 
   * @param m the actual value of the progress.
   */
  public void setCurrentAmount(int m);
}
