package de.das.encrypter.processors;

/**
 * Interface for classes which want to receiver random floating point values 
 * from the random factor generator.
 * 
 * @author Frank Keldenich
 */
public interface RandomFactorReceiver 
{
  /**
   * Gets random floating point numbers from a random factor generator in the 
   * range [0.0 .. 1.0].
   * 
   * @param rf a floating point value.
   */
  public void setRandomFactor(double rf);
}
