package de.das.encrypter.processors;

/**
 * Interface for classes which want to get information about the result of 
 * transfer operations.

* @author Frank Keldenich
 */
public interface ResultReceiver 
{
  /**
   * Indicates that the result is from a communication test. The additional 
   * information provides information about the availability of the requested 
   * key (OK) or its absence (NOK).
   */
  public static final int PARTNER_RESPONSE = 0;
  
  /**
   * Indicates that the previous transfer failed.
   */
  public static final int TRANSFER_FAILED = 1;
  
  /**
   * Indicates that the previous transfer was successful.
   */
  public static final int TRANSFER_VALID = 2;
  
  /**
   * Indicates the interruption of the transmission because an error has 
   * occurred on the receiver side.
   */
  public static final int TRANSFER_BREAK = 3;
  
  /**
   * Sets the result and additional info of a transfer operation.
   * 
   * @param result the result of the transfer operation.
   * @param info an additional info if required.
   */
  public void setResult (int result, String info);
  
  public static String [] RESULT_STRINGS = 
  {
    "Partner response",
    "Transfer failed",
    "Transfer valid",
    "Transfer break;",
  };
}
