package de.das.encrypter.tools;

import static java.lang.Thread.sleep;

/**
 * Base class for all threads that will perform periodical actions.
 * 
 * @author KeldenichF
 */
public abstract class BaseThread extends Thread
{

  public  long    threadID         =     0;
  private boolean killed           =     false;
  private boolean m_bTerminated    =     false;
  private long    sleepTimeMin     =       0;                     // 0 ms
  private long    sleepTimeMax     =     1000 * 60 * 60 * 24 * 2; // 2 Tage
  private long    sleepTime        =      20;  //Default

  public BaseThread ()
  {
    super();
  }

  public long getThreadID()
  {
    return threadID;
  }

  @Override
  @SuppressWarnings("empty-statement")
  public void run()
  {
    prolog();
    while (!killed)
    {
      doTask();      
      try
      {
        sleep (sleepTime);
      }
      catch (InterruptedException ix)
      {;}
    }
    finish();
  }

  public abstract void  doTask();
  
  public void prolog()
  {
  }

  public void finish()
  {
    m_bTerminated = true;
  }

  public synchronized void setSleepTime(long t)
  {
    if ((t >= sleepTimeMin) && (t <= sleepTimeMax))
    {
      sleepTime = t;
    }
  }

  public synchronized long getSleepTime()
  {
    return sleepTime;
  }

  public synchronized void setSleepTimeMin(long t)
  {
    if ((t >= 10) && (t <= sleepTimeMax))
    {
      sleepTime = t;
    }
  }

  public synchronized void setSleepTimeMax(long t)
  {
    if ((t >= 10) && (t >= sleepTimeMin))
    {
      sleepTime = t;
    }
  }

  public synchronized void kill()
  {
    if (!killed)
    {
      killed = true;
      this.interrupt();
    }
  }

  public boolean isKilled()
  {
    return killed;
  }

  public boolean isTerminated()
  {
    return m_bTerminated;  
  }
  
}
