package de.das.encrypter.tools;

/**
 * Byte array enclosers interweave the bits of the individual bytes of a byte 
 * array with the bytes of suitable containers. Suitable containers are files 
 * where the least significant bits of their bytes can be set arbitrarily 
 * without causing detectable damage to the representation of the file contents.
 * <br><br>
 * Examples of such containers are, for example, images where the RGB values are 
 * stored uncompressed or whose RGB values are not changed by the compression. 
 * Audio files in WAV format can also be used. Both when viewing the images and 
 * playing the audio files, the interwoven data cannot be detected.
 * <br><br>
 * Before data is interwoven with the bytes of a container, they are preceded by 
 * an identifier and four bytes (little endian) with the number of bytes 
 * interwoven. Thus it can be determined already at few first bytes of a 
 * container whether the container contains woven in data and how many there 
 * are.<br><br>
 * When files are woven in, the identifier and length information are followed 
 * by another identifier, two bytes representing the length of the following 
 * filename (little endian), and the bytes of the filename itself.
 * 
 * @author Dipl.-Phys. Ing. Frank Keldenich
 */
public class ByteArrayEncloser 
{
  /**
   * An identifier that is prepended to the actual data, so that it is possible 
   * to recognize already during the recovery of a few bytes whether there is 
   * woven data in a possible container or not.
   */
  public static final byte [] ID = "#HD#".getBytes();
  
  /**
   * An additional identifier for the information preceding the data to be woven 
   * in, indicating that the data woven in is a file.
   */
  public static final byte [] HIDDEN_FILE_ID = "####".getBytes();
}
