package de.das.encrypter.tools;
/**
 * This class includes the methods to calculate the CRC's.
 */
public class CRC
{
     
   public static int getCRC_16 (byte[] data)
   {
     return getCRC_16(data, 0);
   }
   
   /**
    * Generates a CRC16 checksum for the given byte array without the number of 
    * bytes specified by the value "ignore" at the end of the byte array.
    * 
    * @param data a given byte array.
    * @param ignore the number of bytes at the end of the byte array.
    * @return the generated CRC16 value.
    */
   public static int getCRC_16 (byte[] data, int ignore)
   {
      int crcValue;
      int i;
     
      crcValue = 0xFFFF;
      
         for (i = 0; i < data.length - ignore; i++)
         {
            crcValue = CRC_16_byte(crcValue, data[i]); 
         }
      return crcValue & 0xFFFF;
   }
   
   /** Method which belongs to the calculation of 16-Bit CRC.*/
   public static int CRC_16_byte (int prevValue, byte nextByte)
   {
      int generator16 = 0x1021;
      int shiftReg;
      int leadingBit;
      int i;
      
      shiftReg = prevValue ^ ((int) nextByte << 8);
      
      for (i = 0; i < 8; i++)
      {
         leadingBit = shiftReg & 0x8000;
         shiftReg = shiftReg << 1;
         
         if (leadingBit == 0x8000)
         {
            shiftReg = shiftReg ^ generator16;
         }
      }
      
      return shiftReg;
   }

  private static final long generator = 0x04C11DB7L;
 
  /**
   * Method to determine the CRC-32 values for a given byte array.
   * CRC start value is set to 0xFFFFFFFF and the generator polynom is
   * 0x04C11DB7L according to IEEE 802.3<br>
   * 
   * @param data a byte array for which a CRC-32 value is requested.
   * 
   * @return the CRC-32 value over the given data.
   */
  public static long getCRC_32(byte[] data)
  {
    return getCRC_32(data, 0);
  }
 
  /**
   * Method to determine the CRC-32 values for a given byte array.
   * CRC start value is set to 0xFFFFFFFF and the generator polynom is
   * 0x04C11DB7L according to IEEE 802.3<br>
   * 
   * @param data a byte array for which a CRC-32 value is requested.
   * @param omit the number of bytes at the end of the array not to include.
   * 
   * @return the CRC-32 value over the given data.
   */
  public static long getCRC_32(byte[] data, int omit)
  {
    long crcValue;
    int i;

    crcValue = 0xFFFFFFFFL;

    for (i = 0; i < data.length - omit; i++)
    {
      crcValue = CRC_32_byte(crcValue, data[i]);
    }
    return ((crcValue ^ 0xFFFFFFFFL) & 0xFFFFFFFFL);
  }
   
  /**
   * Processing of one byte to create a CRC-32 value for a byte array.
   * 
   * @param prevValue
   * @param nextByte
   * @return 
   */
  public static long CRC_32_byte(long prevValue, byte nextByte)
  {
    long shiftReg;
    long leadingBit;
    int i;

    shiftReg = prevValue ^ (((long) nextByte) << 24);

    for (i = 0; i < 8; i++)
    {
      leadingBit = shiftReg & 0x80000000L;
      shiftReg = shiftReg << 1;
      if (leadingBit == 0x80000000L)
      {
        shiftReg = shiftReg ^ generator;
      }
    }
    return shiftReg;
  }

 
}
