package de.das.encrypter.tools;

import java.util.ArrayList;

/**
 *
 * @author Dipl.-Phys. Ing. Frank Keldenich
 */
public class Compensator 
{
  private int count = 0;
  
  private final int size;
  
  private final ArrayList < Long > comp = new ArrayList <> ();
  
  private final Object LOCK = new Object();

  public Compensator(int size) 
  {
    this.size = size;
    init();
  }

  private void init() 
  {
  }
  
  public void setValue(long v)
  {
    if (comp.size() == size)
    {
      comp.remove(0);
    }
    else
    {
      count++;
    }
    comp.add(v);
  }
  
  public long getAverage()
  {
    long ave = 0;
    for (int i = 0; i < count; i++)
    {
      ave = ave + comp.get(i);
    }
    return (long) (ave / (double)count);
  }
  
  public void clear ()
  {
    comp.clear();
    count = 0;
  }
}
