package de.das.encrypter.tools;

import de.das.encrypter.model.KeyFile;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * This class is used together with the swing class JFileChooser and restricts 
 * the file selection offer to valid key bundles.
 * 
 * @author Dipl.-Phys. Ing. Frank Keldenich
 */
public class KeyFileFileFilter extends FileFilter
{
  private final String description;

  /**
   * Create a new instance of KeyFileFileFIlter.
   * @param desc a language dependent description used by this file filter.
   */
  public KeyFileFileFilter(String desc)
  {
    super ();
    this.description = desc;
  }
  
  /**
   * Whether the given file is accepted by this filter.
   *
   * @param f the File to test
   * @return true if the file is to be accepted
   */
  @Override
  public boolean accept(File f) 
  {
    boolean accept = f.isDirectory() || KeyFile.isValidKey(f, true);
    return accept;
  }

  /**
   * Returns the description of the file filter.
   * @return the description of the file filter.
   */
  @Override
  public String getDescription() 
  {
    return description;
  }

}
